package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Selector(
    fieldName: Optional[String] = Optional.Absent,
    operator: Optional[zio.aws.datapipeline.model.Operator] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.Selector = {
    import Selector.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.Selector
      .builder()
      .optionallyWith(fieldName.map(value => value: java.lang.String))(
        _.fieldName
      )
      .optionallyWith(operator.map(value => value.buildAwsValue()))(_.operator)
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.Selector.ReadOnly =
    zio.aws.datapipeline.model.Selector.wrap(buildAwsValue())
}
object Selector {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.Selector
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.Selector =
      zio.aws.datapipeline.model.Selector(
        fieldName.map(value => value),
        operator.map(value => value.asEditable)
      )
    def fieldName: Optional[String]
    def operator: Optional[zio.aws.datapipeline.model.Operator.ReadOnly]
    def getFieldName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fieldName", fieldName)
    def getOperator
        : ZIO[Any, AwsError, zio.aws.datapipeline.model.Operator.ReadOnly] =
      AwsError.unwrapOptionField("operator", operator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.Selector
  ) extends zio.aws.datapipeline.model.Selector.ReadOnly {
    override val fieldName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.fieldName())
      .map(value => value: String)
    override val operator
        : Optional[zio.aws.datapipeline.model.Operator.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operator())
        .map(value => zio.aws.datapipeline.model.Operator.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.Selector
  ): zio.aws.datapipeline.model.Selector.ReadOnly = new Wrapper(impl)
}
