package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datapipeline.model.primitives.Id
import scala.jdk.CollectionConverters._
final case class DeletePipelineRequest(pipelineId: Id) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.DeletePipelineRequest = {
    import DeletePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.DeletePipelineRequest
      .builder()
      .pipelineId(Id.unwrap(pipelineId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.DeletePipelineRequest.ReadOnly =
    zio.aws.datapipeline.model.DeletePipelineRequest.wrap(buildAwsValue())
}
object DeletePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.DeletePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.DeletePipelineRequest =
      zio.aws.datapipeline.model.DeletePipelineRequest(pipelineId)
    def pipelineId: Id
    def getPipelineId: ZIO[Any, Nothing, Id] = ZIO.succeed(pipelineId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.DeletePipelineRequest
  ) extends zio.aws.datapipeline.model.DeletePipelineRequest.ReadOnly {
    override val pipelineId: Id =
      zio.aws.datapipeline.model.primitives.Id(impl.pipelineId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.DeletePipelineRequest
  ): zio.aws.datapipeline.model.DeletePipelineRequest.ReadOnly = new Wrapper(
    impl
  )
}
