package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datapipeline.model.primitives.Id
import scala.jdk.CollectionConverters._
final case class ValidatePipelineDefinitionRequest(
    pipelineId: Id,
    pipelineObjects: Iterable[zio.aws.datapipeline.model.PipelineObject],
    parameterObjects: Optional[
      Iterable[zio.aws.datapipeline.model.ParameterObject]
    ] = Optional.Absent,
    parameterValues: Optional[
      Iterable[zio.aws.datapipeline.model.ParameterValue]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.ValidatePipelineDefinitionRequest = {
    import ValidatePipelineDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.ValidatePipelineDefinitionRequest
      .builder()
      .pipelineId(Id.unwrap(pipelineId): java.lang.String)
      .pipelineObjects(pipelineObjects.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        parameterObjects.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameterObjects)
      .optionallyWith(
        parameterValues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameterValues)
      .build()
  }
  def asReadOnly
      : zio.aws.datapipeline.model.ValidatePipelineDefinitionRequest.ReadOnly =
    zio.aws.datapipeline.model.ValidatePipelineDefinitionRequest
      .wrap(buildAwsValue())
}
object ValidatePipelineDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.ValidatePipelineDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.datapipeline.model.ValidatePipelineDefinitionRequest =
      zio.aws.datapipeline.model.ValidatePipelineDefinitionRequest(
        pipelineId,
        pipelineObjects.map { item =>
          item.asEditable
        },
        parameterObjects.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        parameterValues.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def pipelineId: Id
    def pipelineObjects
        : List[zio.aws.datapipeline.model.PipelineObject.ReadOnly]
    def parameterObjects
        : Optional[List[zio.aws.datapipeline.model.ParameterObject.ReadOnly]]
    def parameterValues
        : Optional[List[zio.aws.datapipeline.model.ParameterValue.ReadOnly]]
    def getPipelineId: ZIO[Any, Nothing, Id] = ZIO.succeed(pipelineId)
    def getPipelineObjects: ZIO[Any, Nothing, List[
      zio.aws.datapipeline.model.PipelineObject.ReadOnly
    ]] = ZIO.succeed(pipelineObjects)
    def getParameterObjects: ZIO[Any, AwsError, List[
      zio.aws.datapipeline.model.ParameterObject.ReadOnly
    ]] = AwsError.unwrapOptionField("parameterObjects", parameterObjects)
    def getParameterValues: ZIO[Any, AwsError, List[
      zio.aws.datapipeline.model.ParameterValue.ReadOnly
    ]] = AwsError.unwrapOptionField("parameterValues", parameterValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.ValidatePipelineDefinitionRequest
  ) extends zio.aws.datapipeline.model.ValidatePipelineDefinitionRequest.ReadOnly {
    override val pipelineId: Id =
      zio.aws.datapipeline.model.primitives.Id(impl.pipelineId())
    override val pipelineObjects
        : List[zio.aws.datapipeline.model.PipelineObject.ReadOnly] = impl
      .pipelineObjects()
      .asScala
      .map { item =>
        zio.aws.datapipeline.model.PipelineObject.wrap(item)
      }
      .toList
    override val parameterObjects
        : Optional[List[zio.aws.datapipeline.model.ParameterObject.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameterObjects())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datapipeline.model.ParameterObject.wrap(item)
          }.toList
        )
    override val parameterValues
        : Optional[List[zio.aws.datapipeline.model.ParameterValue.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameterValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datapipeline.model.ParameterValue.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.ValidatePipelineDefinitionRequest
  ): zio.aws.datapipeline.model.ValidatePipelineDefinitionRequest.ReadOnly =
    new Wrapper(impl)
}
