package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datapipeline.model.primitives.Id
import scala.jdk.CollectionConverters._
final case class ReportTaskRunnerHeartbeatRequest(
    taskrunnerId: Id,
    workerGroup: Optional[String] = Optional.Absent,
    hostname: Optional[Id] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest = {
    import ReportTaskRunnerHeartbeatRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest
      .builder()
      .taskrunnerId(Id.unwrap(taskrunnerId): java.lang.String)
      .optionallyWith(workerGroup.map(value => value: java.lang.String))(
        _.workerGroup
      )
      .optionallyWith(
        hostname.map(value => Id.unwrap(value): java.lang.String)
      )(_.hostname)
      .build()
  }
  def asReadOnly
      : zio.aws.datapipeline.model.ReportTaskRunnerHeartbeatRequest.ReadOnly =
    zio.aws.datapipeline.model.ReportTaskRunnerHeartbeatRequest
      .wrap(buildAwsValue())
}
object ReportTaskRunnerHeartbeatRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.datapipeline.model.ReportTaskRunnerHeartbeatRequest =
      zio.aws.datapipeline.model.ReportTaskRunnerHeartbeatRequest(
        taskrunnerId,
        workerGroup.map(value => value),
        hostname.map(value => value)
      )
    def taskrunnerId: Id
    def workerGroup: Optional[String]
    def hostname: Optional[Id]
    def getTaskrunnerId: ZIO[Any, Nothing, Id] = ZIO.succeed(taskrunnerId)
    def getWorkerGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("workerGroup", workerGroup)
    def getHostname: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("hostname", hostname)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest
  ) extends zio.aws.datapipeline.model.ReportTaskRunnerHeartbeatRequest.ReadOnly {
    override val taskrunnerId: Id =
      zio.aws.datapipeline.model.primitives.Id(impl.taskrunnerId())
    override val workerGroup: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.workerGroup())
      .map(value => value: String)
    override val hostname: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.hostname())
      .map(value => zio.aws.datapipeline.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest
  ): zio.aws.datapipeline.model.ReportTaskRunnerHeartbeatRequest.ReadOnly =
    new Wrapper(impl)
}
