package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datapipeline.model.primitives.{
  AttributeValueString,
  AttributeNameString
}
import scala.jdk.CollectionConverters._
final case class ParameterAttribute(
    key: AttributeNameString,
    stringValue: AttributeValueString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.ParameterAttribute = {
    import ParameterAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.ParameterAttribute
      .builder()
      .key(AttributeNameString.unwrap(key): java.lang.String)
      .stringValue(AttributeValueString.unwrap(stringValue): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.ParameterAttribute.ReadOnly =
    zio.aws.datapipeline.model.ParameterAttribute.wrap(buildAwsValue())
}
object ParameterAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.ParameterAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.ParameterAttribute =
      zio.aws.datapipeline.model.ParameterAttribute(key, stringValue)
    def key: AttributeNameString
    def stringValue: AttributeValueString
    def getKey: ZIO[Any, Nothing, AttributeNameString] = ZIO.succeed(key)
    def getStringValue: ZIO[Any, Nothing, AttributeValueString] =
      ZIO.succeed(stringValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.ParameterAttribute
  ) extends zio.aws.datapipeline.model.ParameterAttribute.ReadOnly {
    override val key: AttributeNameString =
      zio.aws.datapipeline.model.primitives.AttributeNameString(impl.key())
    override val stringValue: AttributeValueString =
      zio.aws.datapipeline.model.primitives
        .AttributeValueString(impl.stringValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.ParameterAttribute
  ): zio.aws.datapipeline.model.ParameterAttribute.ReadOnly = new Wrapper(impl)
}
