package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datapipeline.model.primitives.{Id, TaskId}
import scala.jdk.CollectionConverters._
final case class TaskObject(
    taskId: Optional[TaskId] = Optional.Absent,
    pipelineId: Optional[Id] = Optional.Absent,
    attemptId: Optional[Id] = Optional.Absent,
    objects: Optional[Map[Id, zio.aws.datapipeline.model.PipelineObject]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.TaskObject = {
    import TaskObject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.TaskObject
      .builder()
      .optionallyWith(
        taskId.map(value => TaskId.unwrap(value): java.lang.String)
      )(_.taskId)
      .optionallyWith(
        pipelineId.map(value => Id.unwrap(value): java.lang.String)
      )(_.pipelineId)
      .optionallyWith(
        attemptId.map(value => Id.unwrap(value): java.lang.String)
      )(_.attemptId)
      .optionallyWith(
        objects.map(value =>
          value
            .map({ case (key, value) =>
              (Id.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.objects)
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.TaskObject.ReadOnly =
    zio.aws.datapipeline.model.TaskObject.wrap(buildAwsValue())
}
object TaskObject {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.TaskObject
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.TaskObject =
      zio.aws.datapipeline.model.TaskObject(
        taskId.map(value => value),
        pipelineId.map(value => value),
        attemptId.map(value => value),
        objects.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def taskId: Optional[TaskId]
    def pipelineId: Optional[Id]
    def attemptId: Optional[Id]
    def objects
        : Optional[Map[Id, zio.aws.datapipeline.model.PipelineObject.ReadOnly]]
    def getTaskId: ZIO[Any, AwsError, TaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
    def getPipelineId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("pipelineId", pipelineId)
    def getAttemptId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("attemptId", attemptId)
    def getObjects: ZIO[Any, AwsError, Map[
      Id,
      zio.aws.datapipeline.model.PipelineObject.ReadOnly
    ]] = AwsError.unwrapOptionField("objects", objects)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.TaskObject
  ) extends zio.aws.datapipeline.model.TaskObject.ReadOnly {
    override val taskId: Optional[TaskId] = zio.aws.core.internal
      .optionalFromNullable(impl.taskId())
      .map(value => zio.aws.datapipeline.model.primitives.TaskId(value))
    override val pipelineId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.pipelineId())
      .map(value => zio.aws.datapipeline.model.primitives.Id(value))
    override val attemptId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.attemptId())
      .map(value => zio.aws.datapipeline.model.primitives.Id(value))
    override val objects: Optional[
      Map[Id, zio.aws.datapipeline.model.PipelineObject.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.objects())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.datapipeline.model.primitives
              .Id(key) -> zio.aws.datapipeline.model.PipelineObject.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.TaskObject
  ): zio.aws.datapipeline.model.TaskObject.ReadOnly = new Wrapper(impl)
}
