package zio.aws.datapipeline
import zio.aws.datapipeline.model.DescribePipelinesResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.datapipeline.model.primitives.Id
import zio.aws.datapipeline.model.{
  PutPipelineDefinitionRequest,
  ReportTaskProgressRequest,
  DescribePipelinesRequest,
  ValidatePipelineDefinitionRequest,
  SetStatusRequest,
  ListPipelinesRequest,
  ActivatePipelineRequest,
  AddTagsRequest,
  EvaluateExpressionRequest,
  QueryObjectsRequest,
  DeletePipelineRequest,
  DescribeObjectsRequest,
  CreatePipelineRequest,
  ReportTaskRunnerHeartbeatRequest,
  DeactivatePipelineRequest,
  RemoveTagsRequest,
  PollForTaskRequest,
  SetTaskStatusRequest,
  GetPipelineDefinitionRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.datapipeline.DataPipelineAsyncClient
object DataPipelineMock extends Mock[DataPipeline] {
  object SetTaskStatus
      extends Effect[
        SetTaskStatusRequest,
        AwsError,
        zio.aws.datapipeline.model.SetTaskStatusResponse.ReadOnly
      ]
  object PollForTask
      extends Effect[
        PollForTaskRequest,
        AwsError,
        zio.aws.datapipeline.model.PollForTaskResponse.ReadOnly
      ]
  object ActivatePipeline
      extends Effect[
        ActivatePipelineRequest,
        AwsError,
        zio.aws.datapipeline.model.ActivatePipelineResponse.ReadOnly
      ]
  object AddTags
      extends Effect[
        AddTagsRequest,
        AwsError,
        zio.aws.datapipeline.model.AddTagsResponse.ReadOnly
      ]
  object DescribeObjects
      extends Stream[
        DescribeObjectsRequest,
        AwsError,
        zio.aws.datapipeline.model.PipelineObject.ReadOnly
      ]
  object DescribeObjectsPaginated
      extends Effect[
        DescribeObjectsRequest,
        AwsError,
        zio.aws.datapipeline.model.DescribeObjectsResponse.ReadOnly
      ]
  object ReportTaskRunnerHeartbeat
      extends Effect[
        ReportTaskRunnerHeartbeatRequest,
        AwsError,
        zio.aws.datapipeline.model.ReportTaskRunnerHeartbeatResponse.ReadOnly
      ]
  object ListPipelines
      extends Stream[
        ListPipelinesRequest,
        AwsError,
        zio.aws.datapipeline.model.PipelineIdName.ReadOnly
      ]
  object ListPipelinesPaginated
      extends Effect[
        ListPipelinesRequest,
        AwsError,
        zio.aws.datapipeline.model.ListPipelinesResponse.ReadOnly
      ]
  object PutPipelineDefinition
      extends Effect[
        PutPipelineDefinitionRequest,
        AwsError,
        zio.aws.datapipeline.model.PutPipelineDefinitionResponse.ReadOnly
      ]
  object RemoveTags
      extends Effect[
        RemoveTagsRequest,
        AwsError,
        zio.aws.datapipeline.model.RemoveTagsResponse.ReadOnly
      ]
  object GetPipelineDefinition
      extends Effect[
        GetPipelineDefinitionRequest,
        AwsError,
        zio.aws.datapipeline.model.GetPipelineDefinitionResponse.ReadOnly
      ]
  object DeactivatePipeline
      extends Effect[
        DeactivatePipelineRequest,
        AwsError,
        zio.aws.datapipeline.model.DeactivatePipelineResponse.ReadOnly
      ]
  object SetStatus extends Effect[SetStatusRequest, AwsError, Unit]
  object ReportTaskProgress
      extends Effect[
        ReportTaskProgressRequest,
        AwsError,
        zio.aws.datapipeline.model.ReportTaskProgressResponse.ReadOnly
      ]
  object DescribePipelines
      extends Effect[DescribePipelinesRequest, AwsError, ReadOnly]
  object DeletePipeline extends Effect[DeletePipelineRequest, AwsError, Unit]
  object ValidatePipelineDefinition
      extends Effect[
        ValidatePipelineDefinitionRequest,
        AwsError,
        zio.aws.datapipeline.model.ValidatePipelineDefinitionResponse.ReadOnly
      ]
  object EvaluateExpression
      extends Effect[
        EvaluateExpressionRequest,
        AwsError,
        zio.aws.datapipeline.model.EvaluateExpressionResponse.ReadOnly
      ]
  object CreatePipeline
      extends Effect[
        CreatePipelineRequest,
        AwsError,
        zio.aws.datapipeline.model.CreatePipelineResponse.ReadOnly
      ]
  object QueryObjects extends Stream[QueryObjectsRequest, AwsError, Id]
  object QueryObjectsPaginated
      extends Effect[
        QueryObjectsRequest,
        AwsError,
        zio.aws.datapipeline.model.QueryObjectsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, DataPipeline] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, DataPipeline] { rts =>
        zio.ZIO.succeed {
          new DataPipeline {
            val api: DataPipelineAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): DataPipeline = this
            def setTaskStatus(request: SetTaskStatusRequest): IO[
              AwsError,
              zio.aws.datapipeline.model.SetTaskStatusResponse.ReadOnly
            ] = proxy(SetTaskStatus, request)
            def pollForTask(request: PollForTaskRequest): IO[
              AwsError,
              zio.aws.datapipeline.model.PollForTaskResponse.ReadOnly
            ] = proxy(PollForTask, request)
            def activatePipeline(request: ActivatePipelineRequest): IO[
              AwsError,
              zio.aws.datapipeline.model.ActivatePipelineResponse.ReadOnly
            ] = proxy(ActivatePipeline, request)
            def addTags(request: AddTagsRequest): IO[
              AwsError,
              zio.aws.datapipeline.model.AddTagsResponse.ReadOnly
            ] = proxy(AddTags, request)
            def describeObjects(request: DescribeObjectsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.datapipeline.model.PipelineObject.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeObjects, request))
            def describeObjectsPaginated(request: DescribeObjectsRequest): IO[
              AwsError,
              zio.aws.datapipeline.model.DescribeObjectsResponse.ReadOnly
            ] = proxy(DescribeObjectsPaginated, request)
            def reportTaskRunnerHeartbeat(
                request: ReportTaskRunnerHeartbeatRequest
            ): IO[
              AwsError,
              zio.aws.datapipeline.model.ReportTaskRunnerHeartbeatResponse.ReadOnly
            ] = proxy(ReportTaskRunnerHeartbeat, request)
            def listPipelines(request: ListPipelinesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.datapipeline.model.PipelineIdName.ReadOnly
            ] = rts.unsafeRun(proxy(ListPipelines, request))
            def listPipelinesPaginated(request: ListPipelinesRequest): IO[
              AwsError,
              zio.aws.datapipeline.model.ListPipelinesResponse.ReadOnly
            ] = proxy(ListPipelinesPaginated, request)
            def putPipelineDefinition(
                request: PutPipelineDefinitionRequest
            ): IO[
              AwsError,
              zio.aws.datapipeline.model.PutPipelineDefinitionResponse.ReadOnly
            ] = proxy(PutPipelineDefinition, request)
            def removeTags(request: RemoveTagsRequest): IO[
              AwsError,
              zio.aws.datapipeline.model.RemoveTagsResponse.ReadOnly
            ] = proxy(RemoveTags, request)
            def getPipelineDefinition(
                request: GetPipelineDefinitionRequest
            ): IO[
              AwsError,
              zio.aws.datapipeline.model.GetPipelineDefinitionResponse.ReadOnly
            ] = proxy(GetPipelineDefinition, request)
            def deactivatePipeline(request: DeactivatePipelineRequest): IO[
              AwsError,
              zio.aws.datapipeline.model.DeactivatePipelineResponse.ReadOnly
            ] = proxy(DeactivatePipeline, request)
            def setStatus(request: SetStatusRequest): IO[AwsError, Unit] =
              proxy(SetStatus, request)
            def reportTaskProgress(request: ReportTaskProgressRequest): IO[
              AwsError,
              zio.aws.datapipeline.model.ReportTaskProgressResponse.ReadOnly
            ] = proxy(ReportTaskProgress, request)
            def describePipelines(
                request: DescribePipelinesRequest
            ): IO[AwsError, ReadOnly] = proxy(DescribePipelines, request)
            def deletePipeline(
                request: DeletePipelineRequest
            ): IO[AwsError, Unit] = proxy(DeletePipeline, request)
            def validatePipelineDefinition(
                request: ValidatePipelineDefinitionRequest
            ): IO[
              AwsError,
              zio.aws.datapipeline.model.ValidatePipelineDefinitionResponse.ReadOnly
            ] = proxy(ValidatePipelineDefinition, request)
            def evaluateExpression(request: EvaluateExpressionRequest): IO[
              AwsError,
              zio.aws.datapipeline.model.EvaluateExpressionResponse.ReadOnly
            ] = proxy(EvaluateExpression, request)
            def createPipeline(request: CreatePipelineRequest): IO[
              AwsError,
              zio.aws.datapipeline.model.CreatePipelineResponse.ReadOnly
            ] = proxy(CreatePipeline, request)
            def queryObjects(
                request: QueryObjectsRequest
            ): ZStream[Any, AwsError, Id] =
              rts.unsafeRun(proxy(QueryObjects, request))
            def queryObjectsPaginated(request: QueryObjectsRequest): IO[
              AwsError,
              zio.aws.datapipeline.model.QueryObjectsResponse.ReadOnly
            ] = proxy(QueryObjectsPaginated, request)
          }
        }
      }
    }
  }
}
