package zio.aws.datapipeline.model
import scala.jdk.CollectionConverters._
sealed trait TaskStatus {
  def unwrap: software.amazon.awssdk.services.datapipeline.model.TaskStatus
}
object TaskStatus {
  def wrap(
      value: software.amazon.awssdk.services.datapipeline.model.TaskStatus
  ): zio.aws.datapipeline.model.TaskStatus = value match {
    case software.amazon.awssdk.services.datapipeline.model.TaskStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datapipeline.model.TaskStatus.FINISHED =>
      val r = FINISHED
      r
    case software.amazon.awssdk.services.datapipeline.model.TaskStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.datapipeline.model.TaskStatus.FALSE =>
      val r = FALSE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datapipeline.model.TaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.datapipeline.model.TaskStatus =
      software.amazon.awssdk.services.datapipeline.model.TaskStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object FINISHED extends zio.aws.datapipeline.model.TaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.datapipeline.model.TaskStatus =
      software.amazon.awssdk.services.datapipeline.model.TaskStatus.FINISHED
  }
  case object FAILED extends zio.aws.datapipeline.model.TaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.datapipeline.model.TaskStatus =
      software.amazon.awssdk.services.datapipeline.model.TaskStatus.FAILED
  }
  case object FALSE extends zio.aws.datapipeline.model.TaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.datapipeline.model.TaskStatus =
      software.amazon.awssdk.services.datapipeline.model.TaskStatus.FALSE
  }
}
