package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPipelinesResponse(
    pipelineIdList: Iterable[zio.aws.datapipeline.model.PipelineIdName],
    marker: Optional[String] = Optional.Absent,
    hasMoreResults: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.ListPipelinesResponse = {
    import ListPipelinesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.ListPipelinesResponse
      .builder()
      .pipelineIdList(pipelineIdList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(hasMoreResults.map(value => value: java.lang.Boolean))(
        _.hasMoreResults
      )
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.ListPipelinesResponse.ReadOnly =
    zio.aws.datapipeline.model.ListPipelinesResponse.wrap(buildAwsValue())
}
object ListPipelinesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.ListPipelinesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.ListPipelinesResponse =
      zio.aws.datapipeline.model.ListPipelinesResponse(
        pipelineIdList.map { item =>
          item.asEditable
        },
        marker.map(value => value),
        hasMoreResults.map(value => value)
      )
    def pipelineIdList: List[zio.aws.datapipeline.model.PipelineIdName.ReadOnly]
    def marker: Optional[String]
    def hasMoreResults: Optional[Boolean]
    def getPipelineIdList: ZIO[Any, Nothing, List[
      zio.aws.datapipeline.model.PipelineIdName.ReadOnly
    ]] = ZIO.succeed(pipelineIdList)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getHasMoreResults: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("hasMoreResults", hasMoreResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.ListPipelinesResponse
  ) extends zio.aws.datapipeline.model.ListPipelinesResponse.ReadOnly {
    override val pipelineIdList
        : List[zio.aws.datapipeline.model.PipelineIdName.ReadOnly] = impl
      .pipelineIdList()
      .asScala
      .map { item =>
        zio.aws.datapipeline.model.PipelineIdName.wrap(item)
      }
      .toList
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val hasMoreResults: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.hasMoreResults())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.ListPipelinesResponse
  ): zio.aws.datapipeline.model.ListPipelinesResponse.ReadOnly = new Wrapper(
    impl
  )
}
