package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetPipelineDefinitionResponse(
    pipelineObjects: Optional[
      Iterable[zio.aws.datapipeline.model.PipelineObject]
    ] = Optional.Absent,
    parameterObjects: Optional[
      Iterable[zio.aws.datapipeline.model.ParameterObject]
    ] = Optional.Absent,
    parameterValues: Optional[
      Iterable[zio.aws.datapipeline.model.ParameterValue]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.GetPipelineDefinitionResponse = {
    import GetPipelineDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.GetPipelineDefinitionResponse
      .builder()
      .optionallyWith(
        pipelineObjects.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pipelineObjects)
      .optionallyWith(
        parameterObjects.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameterObjects)
      .optionallyWith(
        parameterValues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameterValues)
      .build()
  }
  def asReadOnly
      : zio.aws.datapipeline.model.GetPipelineDefinitionResponse.ReadOnly =
    zio.aws.datapipeline.model.GetPipelineDefinitionResponse
      .wrap(buildAwsValue())
}
object GetPipelineDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.GetPipelineDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.GetPipelineDefinitionResponse =
      zio.aws.datapipeline.model.GetPipelineDefinitionResponse(
        pipelineObjects.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        parameterObjects.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        parameterValues.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def pipelineObjects
        : Optional[List[zio.aws.datapipeline.model.PipelineObject.ReadOnly]]
    def parameterObjects
        : Optional[List[zio.aws.datapipeline.model.ParameterObject.ReadOnly]]
    def parameterValues
        : Optional[List[zio.aws.datapipeline.model.ParameterValue.ReadOnly]]
    def getPipelineObjects: ZIO[Any, AwsError, List[
      zio.aws.datapipeline.model.PipelineObject.ReadOnly
    ]] = AwsError.unwrapOptionField("pipelineObjects", pipelineObjects)
    def getParameterObjects: ZIO[Any, AwsError, List[
      zio.aws.datapipeline.model.ParameterObject.ReadOnly
    ]] = AwsError.unwrapOptionField("parameterObjects", parameterObjects)
    def getParameterValues: ZIO[Any, AwsError, List[
      zio.aws.datapipeline.model.ParameterValue.ReadOnly
    ]] = AwsError.unwrapOptionField("parameterValues", parameterValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.GetPipelineDefinitionResponse
  ) extends zio.aws.datapipeline.model.GetPipelineDefinitionResponse.ReadOnly {
    override val pipelineObjects
        : Optional[List[zio.aws.datapipeline.model.PipelineObject.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineObjects())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datapipeline.model.PipelineObject.wrap(item)
          }.toList
        )
    override val parameterObjects
        : Optional[List[zio.aws.datapipeline.model.ParameterObject.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameterObjects())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datapipeline.model.ParameterObject.wrap(item)
          }.toList
        )
    override val parameterValues
        : Optional[List[zio.aws.datapipeline.model.ParameterValue.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameterValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datapipeline.model.ParameterValue.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.GetPipelineDefinitionResponse
  ): zio.aws.datapipeline.model.GetPipelineDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
