package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datapipeline.model.primitives.{LongString, Id}
import scala.jdk.CollectionConverters._
final case class EvaluateExpressionRequest(
    pipelineId: Id,
    objectId: Id,
    expression: LongString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.EvaluateExpressionRequest = {
    import EvaluateExpressionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.EvaluateExpressionRequest
      .builder()
      .pipelineId(Id.unwrap(pipelineId): java.lang.String)
      .objectId(Id.unwrap(objectId): java.lang.String)
      .expression(LongString.unwrap(expression): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.datapipeline.model.EvaluateExpressionRequest.ReadOnly =
    zio.aws.datapipeline.model.EvaluateExpressionRequest.wrap(buildAwsValue())
}
object EvaluateExpressionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.EvaluateExpressionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.EvaluateExpressionRequest =
      zio.aws.datapipeline.model
        .EvaluateExpressionRequest(pipelineId, objectId, expression)
    def pipelineId: Id
    def objectId: Id
    def expression: LongString
    def getPipelineId: ZIO[Any, Nothing, Id] = ZIO.succeed(pipelineId)
    def getObjectId: ZIO[Any, Nothing, Id] = ZIO.succeed(objectId)
    def getExpression: ZIO[Any, Nothing, LongString] = ZIO.succeed(expression)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.EvaluateExpressionRequest
  ) extends zio.aws.datapipeline.model.EvaluateExpressionRequest.ReadOnly {
    override val pipelineId: Id =
      zio.aws.datapipeline.model.primitives.Id(impl.pipelineId())
    override val objectId: Id =
      zio.aws.datapipeline.model.primitives.Id(impl.objectId())
    override val expression: LongString =
      zio.aws.datapipeline.model.primitives.LongString(impl.expression())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.EvaluateExpressionRequest
  ): zio.aws.datapipeline.model.EvaluateExpressionRequest.ReadOnly =
    new Wrapper(impl)
}
