package zio.aws.datapipeline.model
import scala.jdk.CollectionConverters._
sealed trait OperatorType {
  def unwrap: software.amazon.awssdk.services.datapipeline.model.OperatorType
}
object OperatorType {
  def wrap(
      value: software.amazon.awssdk.services.datapipeline.model.OperatorType
  ): zio.aws.datapipeline.model.OperatorType = value match {
    case software.amazon.awssdk.services.datapipeline.model.OperatorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datapipeline.model.OperatorType.EQ =>
      val r = EQ
      r
    case software.amazon.awssdk.services.datapipeline.model.OperatorType.REF_EQ =>
      val r = REF_EQ
      r
    case software.amazon.awssdk.services.datapipeline.model.OperatorType.LE =>
      val r = LE
      r
    case software.amazon.awssdk.services.datapipeline.model.OperatorType.GE =>
      val r = GE
      r
    case software.amazon.awssdk.services.datapipeline.model.OperatorType.BETWEEN =>
      val r = BETWEEN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datapipeline.model.OperatorType {
    override def unwrap
        : software.amazon.awssdk.services.datapipeline.model.OperatorType =
      software.amazon.awssdk.services.datapipeline.model.OperatorType.UNKNOWN_TO_SDK_VERSION
  }
  case object EQ extends zio.aws.datapipeline.model.OperatorType {
    override def unwrap
        : software.amazon.awssdk.services.datapipeline.model.OperatorType =
      software.amazon.awssdk.services.datapipeline.model.OperatorType.EQ
  }
  case object REF_EQ extends zio.aws.datapipeline.model.OperatorType {
    override def unwrap
        : software.amazon.awssdk.services.datapipeline.model.OperatorType =
      software.amazon.awssdk.services.datapipeline.model.OperatorType.REF_EQ
  }
  case object LE extends zio.aws.datapipeline.model.OperatorType {
    override def unwrap
        : software.amazon.awssdk.services.datapipeline.model.OperatorType =
      software.amazon.awssdk.services.datapipeline.model.OperatorType.LE
  }
  case object GE extends zio.aws.datapipeline.model.OperatorType {
    override def unwrap
        : software.amazon.awssdk.services.datapipeline.model.OperatorType =
      software.amazon.awssdk.services.datapipeline.model.OperatorType.GE
  }
  case object BETWEEN extends zio.aws.datapipeline.model.OperatorType {
    override def unwrap
        : software.amazon.awssdk.services.datapipeline.model.OperatorType =
      software.amazon.awssdk.services.datapipeline.model.OperatorType.BETWEEN
  }
}
