package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datapipeline.model.primitives.FieldNameString
import scala.jdk.CollectionConverters._
final case class ParameterObject(
    id: FieldNameString,
    attributes: Iterable[zio.aws.datapipeline.model.ParameterAttribute]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.ParameterObject = {
    import ParameterObject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.ParameterObject
      .builder()
      .id(FieldNameString.unwrap(id): java.lang.String)
      .attributes(attributes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.ParameterObject.ReadOnly =
    zio.aws.datapipeline.model.ParameterObject.wrap(buildAwsValue())
}
object ParameterObject {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.ParameterObject
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.ParameterObject =
      zio.aws.datapipeline.model.ParameterObject(
        id,
        attributes.map { item =>
          item.asEditable
        }
      )
    def id: FieldNameString
    def attributes: List[zio.aws.datapipeline.model.ParameterAttribute.ReadOnly]
    def getId: ZIO[Any, Nothing, FieldNameString] = ZIO.succeed(id)
    def getAttributes: ZIO[Any, Nothing, List[
      zio.aws.datapipeline.model.ParameterAttribute.ReadOnly
    ]] = ZIO.succeed(attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.ParameterObject
  ) extends zio.aws.datapipeline.model.ParameterObject.ReadOnly {
    override val id: FieldNameString =
      zio.aws.datapipeline.model.primitives.FieldNameString(impl.id())
    override val attributes
        : List[zio.aws.datapipeline.model.ParameterAttribute.ReadOnly] = impl
      .attributes()
      .asScala
      .map { item =>
        zio.aws.datapipeline.model.ParameterAttribute.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.ParameterObject
  ): zio.aws.datapipeline.model.ParameterObject.ReadOnly = new Wrapper(impl)
}
