package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datapipeline.model.primitives.Id
import scala.jdk.CollectionConverters._
final case class AddTagsRequest(
    pipelineId: Id,
    tags: Iterable[zio.aws.datapipeline.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.AddTagsRequest = {
    import AddTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.AddTagsRequest
      .builder()
      .pipelineId(Id.unwrap(pipelineId): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.AddTagsRequest.ReadOnly =
    zio.aws.datapipeline.model.AddTagsRequest.wrap(buildAwsValue())
}
object AddTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.AddTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.AddTagsRequest =
      zio.aws.datapipeline.model.AddTagsRequest(
        pipelineId,
        tags.map { item =>
          item.asEditable
        }
      )
    def pipelineId: Id
    def tags: List[zio.aws.datapipeline.model.Tag.ReadOnly]
    def getPipelineId: ZIO[Any, Nothing, Id] = ZIO.succeed(pipelineId)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.datapipeline.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.AddTagsRequest
  ) extends zio.aws.datapipeline.model.AddTagsRequest.ReadOnly {
    override val pipelineId: Id =
      zio.aws.datapipeline.model.primitives.Id(impl.pipelineId())
    override val tags: List[zio.aws.datapipeline.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.datapipeline.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.AddTagsRequest
  ): zio.aws.datapipeline.model.AddTagsRequest.ReadOnly = new Wrapper(impl)
}
