package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datapipeline.model.primitives.{ErrorMessage, TaskId}
import scala.jdk.CollectionConverters._
final case class SetTaskStatusRequest(
    taskId: TaskId,
    taskStatus: zio.aws.datapipeline.model.TaskStatus,
    errorId: Optional[String] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent,
    errorStackTrace: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.SetTaskStatusRequest = {
    import SetTaskStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.SetTaskStatusRequest
      .builder()
      .taskId(TaskId.unwrap(taskId): java.lang.String)
      .taskStatus(taskStatus.unwrap)
      .optionallyWith(errorId.map(value => value: java.lang.String))(_.errorId)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(errorStackTrace.map(value => value: java.lang.String))(
        _.errorStackTrace
      )
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.SetTaskStatusRequest.ReadOnly =
    zio.aws.datapipeline.model.SetTaskStatusRequest.wrap(buildAwsValue())
}
object SetTaskStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.SetTaskStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.SetTaskStatusRequest =
      zio.aws.datapipeline.model.SetTaskStatusRequest(
        taskId,
        taskStatus,
        errorId.map(value => value),
        errorMessage.map(value => value),
        errorStackTrace.map(value => value)
      )
    def taskId: TaskId
    def taskStatus: zio.aws.datapipeline.model.TaskStatus
    def errorId: Optional[String]
    def errorMessage: Optional[ErrorMessage]
    def errorStackTrace: Optional[String]
    def getTaskId: ZIO[Any, Nothing, TaskId] = ZIO.succeed(taskId)
    def getTaskStatus
        : ZIO[Any, Nothing, zio.aws.datapipeline.model.TaskStatus] =
      ZIO.succeed(taskStatus)
    def getErrorId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorId", errorId)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getErrorStackTrace: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorStackTrace", errorStackTrace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.SetTaskStatusRequest
  ) extends zio.aws.datapipeline.model.SetTaskStatusRequest.ReadOnly {
    override val taskId: TaskId =
      zio.aws.datapipeline.model.primitives.TaskId(impl.taskId())
    override val taskStatus: zio.aws.datapipeline.model.TaskStatus =
      zio.aws.datapipeline.model.TaskStatus.wrap(impl.taskStatus())
    override val errorId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorId())
      .map(value => value: String)
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.datapipeline.model.primitives.ErrorMessage(value))
    override val errorStackTrace: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorStackTrace())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.SetTaskStatusRequest
  ): zio.aws.datapipeline.model.SetTaskStatusRequest.ReadOnly = new Wrapper(
    impl
  )
}
