package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ValidatePipelineDefinitionResponse(
    validationErrors: Option[
      Iterable[zio.aws.datapipeline.model.ValidationError]
    ] = None,
    validationWarnings: Option[
      Iterable[zio.aws.datapipeline.model.ValidationWarning]
    ] = None,
    errored: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.ValidatePipelineDefinitionResponse = {
    import ValidatePipelineDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.ValidatePipelineDefinitionResponse
      .builder()
      .optionallyWith(
        validationErrors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validationErrors)
      .optionallyWith(
        validationWarnings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validationWarnings)
      .errored(errored: java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.datapipeline.model.ValidatePipelineDefinitionResponse.ReadOnly =
    zio.aws.datapipeline.model.ValidatePipelineDefinitionResponse
      .wrap(buildAwsValue())
}
object ValidatePipelineDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.ValidatePipelineDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.datapipeline.model.ValidatePipelineDefinitionResponse =
      zio.aws.datapipeline.model.ValidatePipelineDefinitionResponse(
        validationErrors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        validationWarnings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        errored
      )
    def validationErrors
        : Option[List[zio.aws.datapipeline.model.ValidationError.ReadOnly]]
    def validationWarnings
        : Option[List[zio.aws.datapipeline.model.ValidationWarning.ReadOnly]]
    def errored: Boolean
    def getValidationErrors: ZIO[Any, AwsError, List[
      zio.aws.datapipeline.model.ValidationError.ReadOnly
    ]] = AwsError.unwrapOptionField("validationErrors", validationErrors)
    def getValidationWarnings: ZIO[Any, AwsError, List[
      zio.aws.datapipeline.model.ValidationWarning.ReadOnly
    ]] = AwsError.unwrapOptionField("validationWarnings", validationWarnings)
    def getErrored: ZIO[Any, Nothing, Boolean] = ZIO.succeed(errored)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.ValidatePipelineDefinitionResponse
  ) extends zio.aws.datapipeline.model.ValidatePipelineDefinitionResponse.ReadOnly {
    override val validationErrors
        : Option[List[zio.aws.datapipeline.model.ValidationError.ReadOnly]] =
      scala
        .Option(impl.validationErrors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datapipeline.model.ValidationError.wrap(item)
          }.toList
        )
    override val validationWarnings
        : Option[List[zio.aws.datapipeline.model.ValidationWarning.ReadOnly]] =
      scala
        .Option(impl.validationWarnings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datapipeline.model.ValidationWarning.wrap(item)
          }.toList
        )
    override val errored: Boolean = impl.errored(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.ValidatePipelineDefinitionResponse
  ): zio.aws.datapipeline.model.ValidatePipelineDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
