package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datapipeline.model.primitives.Id
import scala.jdk.CollectionConverters._
final case class DescribePipelinesRequest(pipelineIds: Iterable[Id]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.DescribePipelinesRequest = {
    import DescribePipelinesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.DescribePipelinesRequest
      .builder()
      .pipelineIds(pipelineIds.map { item =>
        Id.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.DescribePipelinesRequest.ReadOnly =
    zio.aws.datapipeline.model.DescribePipelinesRequest.wrap(buildAwsValue())
}
object DescribePipelinesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.DescribePipelinesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.DescribePipelinesRequest =
      zio.aws.datapipeline.model.DescribePipelinesRequest(pipelineIds)
    def pipelineIds: List[Id]
    def getPipelineIds: ZIO[Any, Nothing, List[Id]] = ZIO.succeed(pipelineIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.DescribePipelinesRequest
  ) extends zio.aws.datapipeline.model.DescribePipelinesRequest.ReadOnly {
    override val pipelineIds: List[Id] = impl
      .pipelineIds()
      .asScala
      .map { item =>
        zio.aws.datapipeline.model.primitives.Id(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.DescribePipelinesRequest
  ): zio.aws.datapipeline.model.DescribePipelinesRequest.ReadOnly = new Wrapper(
    impl
  )
}
