package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.datapipeline.model.primitives.{ValidationMessage, Id}
import scala.jdk.CollectionConverters._
final case class ValidationWarning(
    id: Option[Id] = None,
    warnings: Option[Iterable[ValidationMessage]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.ValidationWarning = {
    import ValidationWarning.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.ValidationWarning
      .builder()
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(
        warnings.map(value =>
          value.map { item =>
            ValidationMessage.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.warnings)
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.ValidationWarning.ReadOnly =
    zio.aws.datapipeline.model.ValidationWarning.wrap(buildAwsValue())
}
object ValidationWarning {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.ValidationWarning
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.ValidationWarning =
      zio.aws.datapipeline.model
        .ValidationWarning(id.map(value => value), warnings.map(value => value))
    def id: Option[Id]
    def warnings: Option[List[ValidationMessage]]
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getWarnings: ZIO[Any, AwsError, List[ValidationMessage]] =
      AwsError.unwrapOptionField("warnings", warnings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.ValidationWarning
  ) extends zio.aws.datapipeline.model.ValidationWarning.ReadOnly {
    override val id: Option[Id] = scala
      .Option(impl.id())
      .map(value => zio.aws.datapipeline.model.primitives.Id(value))
    override val warnings: Option[List[ValidationMessage]] = scala
      .Option(impl.warnings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datapipeline.model.primitives.ValidationMessage(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.ValidationWarning
  ): zio.aws.datapipeline.model.ValidationWarning.ReadOnly = new Wrapper(impl)
}
