package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.datapipeline.model.primitives.{Timestamp, Id}
import scala.jdk.CollectionConverters._
final case class ActivatePipelineRequest(
    pipelineId: Id,
    parameterValues: Option[
      Iterable[zio.aws.datapipeline.model.ParameterValue]
    ] = None,
    startTimestamp: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.ActivatePipelineRequest = {
    import ActivatePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.ActivatePipelineRequest
      .builder()
      .pipelineId(Id.unwrap(pipelineId): java.lang.String)
      .optionallyWith(
        parameterValues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameterValues)
      .optionallyWith(
        startTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.startTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.ActivatePipelineRequest.ReadOnly =
    zio.aws.datapipeline.model.ActivatePipelineRequest.wrap(buildAwsValue())
}
object ActivatePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.ActivatePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.ActivatePipelineRequest =
      zio.aws.datapipeline.model.ActivatePipelineRequest(
        pipelineId,
        parameterValues.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        startTimestamp.map(value => value)
      )
    def pipelineId: Id
    def parameterValues
        : Option[List[zio.aws.datapipeline.model.ParameterValue.ReadOnly]]
    def startTimestamp: Option[Timestamp]
    def getPipelineId: ZIO[Any, Nothing, Id] = ZIO.succeed(pipelineId)
    def getParameterValues: ZIO[Any, AwsError, List[
      zio.aws.datapipeline.model.ParameterValue.ReadOnly
    ]] = AwsError.unwrapOptionField("parameterValues", parameterValues)
    def getStartTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTimestamp", startTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.ActivatePipelineRequest
  ) extends zio.aws.datapipeline.model.ActivatePipelineRequest.ReadOnly {
    override val pipelineId: Id =
      zio.aws.datapipeline.model.primitives.Id(impl.pipelineId())
    override val parameterValues
        : Option[List[zio.aws.datapipeline.model.ParameterValue.ReadOnly]] =
      scala
        .Option(impl.parameterValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datapipeline.model.ParameterValue.wrap(item)
          }.toList
        )
    override val startTimestamp: Option[Timestamp] = scala
      .Option(impl.startTimestamp())
      .map(value => zio.aws.datapipeline.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.ActivatePipelineRequest
  ): zio.aws.datapipeline.model.ActivatePipelineRequest.ReadOnly = new Wrapper(
    impl
  )
}
