package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.datapipeline.model.primitives.Id
import scala.jdk.CollectionConverters._
final case class CreatePipelineRequest(
    name: Id,
    uniqueId: Id,
    description: Option[String] = None,
    tags: Option[Iterable[zio.aws.datapipeline.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.CreatePipelineRequest = {
    import CreatePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.CreatePipelineRequest
      .builder()
      .name(Id.unwrap(name): java.lang.String)
      .uniqueId(Id.unwrap(uniqueId): java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.CreatePipelineRequest.ReadOnly =
    zio.aws.datapipeline.model.CreatePipelineRequest.wrap(buildAwsValue())
}
object CreatePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.CreatePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.CreatePipelineRequest =
      zio.aws.datapipeline.model.CreatePipelineRequest(
        name,
        uniqueId,
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Id
    def uniqueId: Id
    def description: Option[String]
    def tags: Option[List[zio.aws.datapipeline.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, Id] = ZIO.succeed(name)
    def getUniqueId: ZIO[Any, Nothing, Id] = ZIO.succeed(uniqueId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.datapipeline.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.CreatePipelineRequest
  ) extends zio.aws.datapipeline.model.CreatePipelineRequest.ReadOnly {
    override val name: Id =
      zio.aws.datapipeline.model.primitives.Id(impl.name())
    override val uniqueId: Id =
      zio.aws.datapipeline.model.primitives.Id(impl.uniqueId())
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val tags: Option[List[zio.aws.datapipeline.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datapipeline.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.CreatePipelineRequest
  ): zio.aws.datapipeline.model.CreatePipelineRequest.ReadOnly = new Wrapper(
    impl
  )
}
