package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Query(
    selectors: Option[Iterable[zio.aws.datapipeline.model.Selector]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.Query = {
    import Query.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.Query
      .builder()
      .optionallyWith(
        selectors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.selectors)
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.Query.ReadOnly =
    zio.aws.datapipeline.model.Query.wrap(buildAwsValue())
}
object Query {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.Query
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.Query =
      zio.aws.datapipeline.model.Query(
        selectors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def selectors: Option[List[zio.aws.datapipeline.model.Selector.ReadOnly]]
    def getSelectors: ZIO[Any, AwsError, List[
      zio.aws.datapipeline.model.Selector.ReadOnly
    ]] = AwsError.unwrapOptionField("selectors", selectors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.Query
  ) extends zio.aws.datapipeline.model.Query.ReadOnly {
    override val selectors
        : Option[List[zio.aws.datapipeline.model.Selector.ReadOnly]] = scala
      .Option(impl.selectors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datapipeline.model.Selector.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.Query
  ): zio.aws.datapipeline.model.Query.ReadOnly = new Wrapper(impl)
}
