package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.datapipeline.model.primitives.Id
import scala.jdk.CollectionConverters._
final case class QueryObjectsResponse(
    ids: Option[Iterable[Id]] = None,
    marker: Option[String] = None,
    hasMoreResults: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.QueryObjectsResponse = {
    import QueryObjectsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.QueryObjectsResponse
      .builder()
      .optionallyWith(
        ids.map(value =>
          value.map { item =>
            Id.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ids)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(hasMoreResults.map(value => value: java.lang.Boolean))(
        _.hasMoreResults
      )
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.QueryObjectsResponse.ReadOnly =
    zio.aws.datapipeline.model.QueryObjectsResponse.wrap(buildAwsValue())
}
object QueryObjectsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.QueryObjectsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.QueryObjectsResponse =
      zio.aws.datapipeline.model.QueryObjectsResponse(
        ids.map(value => value),
        marker.map(value => value),
        hasMoreResults.map(value => value)
      )
    def ids: Option[List[Id]]
    def marker: Option[String]
    def hasMoreResults: Option[Boolean]
    def getIds: ZIO[Any, AwsError, List[Id]] =
      AwsError.unwrapOptionField("ids", ids)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getHasMoreResults: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("hasMoreResults", hasMoreResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.QueryObjectsResponse
  ) extends zio.aws.datapipeline.model.QueryObjectsResponse.ReadOnly {
    override val ids: Option[List[Id]] = scala
      .Option(impl.ids())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datapipeline.model.primitives.Id(item)
        }.toList
      )
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val hasMoreResults: Option[Boolean] =
      scala.Option(impl.hasMoreResults()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.QueryObjectsResponse
  ): zio.aws.datapipeline.model.QueryObjectsResponse.ReadOnly = new Wrapper(
    impl
  )
}
