package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PollForTaskResponse(
    taskObject: Option[zio.aws.datapipeline.model.TaskObject] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.PollForTaskResponse = {
    import PollForTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.PollForTaskResponse
      .builder()
      .optionallyWith(taskObject.map(value => value.buildAwsValue()))(
        _.taskObject
      )
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.PollForTaskResponse.ReadOnly =
    zio.aws.datapipeline.model.PollForTaskResponse.wrap(buildAwsValue())
}
object PollForTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.PollForTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.PollForTaskResponse =
      zio.aws.datapipeline.model
        .PollForTaskResponse(taskObject.map(value => value.asEditable))
    def taskObject: Option[zio.aws.datapipeline.model.TaskObject.ReadOnly]
    def getTaskObject
        : ZIO[Any, AwsError, zio.aws.datapipeline.model.TaskObject.ReadOnly] =
      AwsError.unwrapOptionField("taskObject", taskObject)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.PollForTaskResponse
  ) extends zio.aws.datapipeline.model.PollForTaskResponse.ReadOnly {
    override val taskObject
        : Option[zio.aws.datapipeline.model.TaskObject.ReadOnly] = scala
      .Option(impl.taskObject())
      .map(value => zio.aws.datapipeline.model.TaskObject.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.PollForTaskResponse
  ): zio.aws.datapipeline.model.PollForTaskResponse.ReadOnly = new Wrapper(impl)
}
