package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.datapipeline.model.primitives.{FieldStringValue, FieldNameString}
import scala.jdk.CollectionConverters._
final case class Field(
    key: FieldNameString,
    stringValue: Option[FieldStringValue] = None,
    refValue: Option[FieldNameString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.Field = {
    import Field.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.Field
      .builder()
      .key(FieldNameString.unwrap(key): java.lang.String)
      .optionallyWith(
        stringValue.map(value =>
          FieldStringValue.unwrap(value): java.lang.String
        )
      )(_.stringValue)
      .optionallyWith(
        refValue.map(value => FieldNameString.unwrap(value): java.lang.String)
      )(_.refValue)
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.Field.ReadOnly =
    zio.aws.datapipeline.model.Field.wrap(buildAwsValue())
}
object Field {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.Field
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.Field =
      zio.aws.datapipeline.model.Field(
        key,
        stringValue.map(value => value),
        refValue.map(value => value)
      )
    def key: FieldNameString
    def stringValue: Option[FieldStringValue]
    def refValue: Option[FieldNameString]
    def getKey: ZIO[Any, Nothing, FieldNameString] = ZIO.succeed(key)
    def getStringValue: ZIO[Any, AwsError, FieldStringValue] =
      AwsError.unwrapOptionField("stringValue", stringValue)
    def getRefValue: ZIO[Any, AwsError, FieldNameString] =
      AwsError.unwrapOptionField("refValue", refValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.Field
  ) extends zio.aws.datapipeline.model.Field.ReadOnly {
    override val key: FieldNameString =
      zio.aws.datapipeline.model.primitives.FieldNameString(impl.key())
    override val stringValue: Option[FieldStringValue] = scala
      .Option(impl.stringValue())
      .map(value =>
        zio.aws.datapipeline.model.primitives.FieldStringValue(value)
      )
    override val refValue: Option[FieldNameString] = scala
      .Option(impl.refValue())
      .map(value =>
        zio.aws.datapipeline.model.primitives.FieldNameString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.Field
  ): zio.aws.datapipeline.model.Field.ReadOnly = new Wrapper(impl)
}
