package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutPipelineDefinitionResponse(
    validationErrors: Option[
      Iterable[zio.aws.datapipeline.model.ValidationError]
    ] = None,
    validationWarnings: Option[
      Iterable[zio.aws.datapipeline.model.ValidationWarning]
    ] = None,
    errored: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.PutPipelineDefinitionResponse = {
    import PutPipelineDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.PutPipelineDefinitionResponse
      .builder()
      .optionallyWith(
        validationErrors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validationErrors)
      .optionallyWith(
        validationWarnings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validationWarnings)
      .errored(errored: java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.datapipeline.model.PutPipelineDefinitionResponse.ReadOnly =
    zio.aws.datapipeline.model.PutPipelineDefinitionResponse
      .wrap(buildAwsValue())
}
object PutPipelineDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.PutPipelineDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.PutPipelineDefinitionResponse =
      zio.aws.datapipeline.model.PutPipelineDefinitionResponse(
        validationErrors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        validationWarnings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        errored
      )
    def validationErrors
        : Option[List[zio.aws.datapipeline.model.ValidationError.ReadOnly]]
    def validationWarnings
        : Option[List[zio.aws.datapipeline.model.ValidationWarning.ReadOnly]]
    def errored: Boolean
    def getValidationErrors: ZIO[Any, AwsError, List[
      zio.aws.datapipeline.model.ValidationError.ReadOnly
    ]] = AwsError.unwrapOptionField("validationErrors", validationErrors)
    def getValidationWarnings: ZIO[Any, AwsError, List[
      zio.aws.datapipeline.model.ValidationWarning.ReadOnly
    ]] = AwsError.unwrapOptionField("validationWarnings", validationWarnings)
    def getErrored: ZIO[Any, Nothing, Boolean] = ZIO.succeed(errored)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.PutPipelineDefinitionResponse
  ) extends zio.aws.datapipeline.model.PutPipelineDefinitionResponse.ReadOnly {
    override val validationErrors
        : Option[List[zio.aws.datapipeline.model.ValidationError.ReadOnly]] =
      scala
        .Option(impl.validationErrors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datapipeline.model.ValidationError.wrap(item)
          }.toList
        )
    override val validationWarnings
        : Option[List[zio.aws.datapipeline.model.ValidationWarning.ReadOnly]] =
      scala
        .Option(impl.validationWarnings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datapipeline.model.ValidationWarning.wrap(item)
          }.toList
        )
    override val errored: Boolean = impl.errored(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.PutPipelineDefinitionResponse
  ): zio.aws.datapipeline.model.PutPipelineDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
