package zio.aws.datapipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Operator(
    `type`: Option[zio.aws.datapipeline.model.OperatorType] = None,
    values: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datapipeline.model.Operator = {
    import Operator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datapipeline.model.Operator
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.datapipeline.model.Operator.ReadOnly =
    zio.aws.datapipeline.model.Operator.wrap(buildAwsValue())
}
object Operator {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datapipeline.model.Operator
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datapipeline.model.Operator =
      zio.aws.datapipeline.model
        .Operator(`type`.map(value => value), values.map(value => value))
    def `type`: Option[zio.aws.datapipeline.model.OperatorType]
    def values: Option[List[String]]
    def getType: ZIO[Any, AwsError, zio.aws.datapipeline.model.OperatorType] =
      AwsError.unwrapOptionField("type", `type`)
    def getValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datapipeline.model.Operator
  ) extends zio.aws.datapipeline.model.Operator.ReadOnly {
    override val `type`: Option[zio.aws.datapipeline.model.OperatorType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.datapipeline.model.OperatorType.wrap(value))
    override val values: Option[List[String]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datapipeline.model.Operator
  ): zio.aws.datapipeline.model.Operator.ReadOnly = new Wrapper(impl)
}
