package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.{
  __string,
  __stringMin0Max16384,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SendDataSetNotificationRequest(
    scope: Optional[zio.aws.dataexchange.model.ScopeDetails] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    comment: Optional[__stringMin0Max16384] = Optional.Absent,
    dataSetId: __string,
    details: Optional[zio.aws.dataexchange.model.NotificationDetails] =
      Optional.Absent,
    `type`: zio.aws.dataexchange.model.NotificationType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.SendDataSetNotificationRequest = {
    import SendDataSetNotificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.SendDataSetNotificationRequest
      .builder()
      .optionallyWith(scope.map(value => value.buildAwsValue()))(_.scope)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(comment.map(value => value: java.lang.String))(_.comment)
      .dataSetId(dataSetId: java.lang.String)
      .optionallyWith(details.map(value => value.buildAwsValue()))(_.details)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.dataexchange.model.SendDataSetNotificationRequest.ReadOnly =
    zio.aws.dataexchange.model.SendDataSetNotificationRequest
      .wrap(buildAwsValue())
}
object SendDataSetNotificationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.SendDataSetNotificationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.SendDataSetNotificationRequest =
      zio.aws.dataexchange.model.SendDataSetNotificationRequest(
        scope.map(value => value.asEditable),
        clientToken.map(value => value),
        comment.map(value => value),
        dataSetId,
        details.map(value => value.asEditable),
        `type`
      )
    def scope: Optional[zio.aws.dataexchange.model.ScopeDetails.ReadOnly]
    def clientToken: Optional[ClientToken]
    def comment: Optional[__stringMin0Max16384]
    def dataSetId: __string
    def details
        : Optional[zio.aws.dataexchange.model.NotificationDetails.ReadOnly]
    def `type`: zio.aws.dataexchange.model.NotificationType
    def getScope
        : ZIO[Any, AwsError, zio.aws.dataexchange.model.ScopeDetails.ReadOnly] =
      AwsError.unwrapOptionField("scope", scope)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getComment: ZIO[Any, AwsError, __stringMin0Max16384] =
      AwsError.unwrapOptionField("comment", comment)
    def getDataSetId: ZIO[Any, Nothing, __string] = ZIO.succeed(dataSetId)
    def getDetails: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.NotificationDetails.ReadOnly
    ] = AwsError.unwrapOptionField("details", details)
    def getType
        : ZIO[Any, Nothing, zio.aws.dataexchange.model.NotificationType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.SendDataSetNotificationRequest
  ) extends zio.aws.dataexchange.model.SendDataSetNotificationRequest.ReadOnly {
    override val scope
        : Optional[zio.aws.dataexchange.model.ScopeDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scope())
        .map(value => zio.aws.dataexchange.model.ScopeDetails.wrap(value))
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.dataexchange.model.primitives.ClientToken(value))
    override val comment: Optional[__stringMin0Max16384] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value => value: __stringMin0Max16384)
    override val dataSetId: __string = impl.dataSetId(): __string
    override val details
        : Optional[zio.aws.dataexchange.model.NotificationDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.details())
        .map(value =>
          zio.aws.dataexchange.model.NotificationDetails.wrap(value)
        )
    override val `type`: zio.aws.dataexchange.model.NotificationType =
      zio.aws.dataexchange.model.NotificationType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.SendDataSetNotificationRequest
  ): zio.aws.dataexchange.model.SendDataSetNotificationRequest.ReadOnly =
    new Wrapper(impl)
}
