package zio.aws.dataexchange.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ScopeDetails(
    lakeFormationTagPolicies: Optional[
      Iterable[zio.aws.dataexchange.model.LakeFormationTagPolicyDetails]
    ] = Optional.Absent,
    redshiftDataShares: Optional[
      Iterable[zio.aws.dataexchange.model.RedshiftDataShareDetails]
    ] = Optional.Absent,
    s3DataAccesses: Optional[
      Iterable[zio.aws.dataexchange.model.S3DataAccessDetails]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ScopeDetails = {
    import ScopeDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ScopeDetails
      .builder()
      .optionallyWith(
        lakeFormationTagPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lakeFormationTagPolicies)
      .optionallyWith(
        redshiftDataShares.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.redshiftDataShares)
      .optionallyWith(
        s3DataAccesses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.s3DataAccesses)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.ScopeDetails.ReadOnly =
    zio.aws.dataexchange.model.ScopeDetails.wrap(buildAwsValue())
}
object ScopeDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ScopeDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.ScopeDetails =
      zio.aws.dataexchange.model.ScopeDetails(
        lakeFormationTagPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        redshiftDataShares.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        s3DataAccesses.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def lakeFormationTagPolicies: Optional[
      List[zio.aws.dataexchange.model.LakeFormationTagPolicyDetails.ReadOnly]
    ]
    def redshiftDataShares: Optional[
      List[zio.aws.dataexchange.model.RedshiftDataShareDetails.ReadOnly]
    ]
    def s3DataAccesses: Optional[
      List[zio.aws.dataexchange.model.S3DataAccessDetails.ReadOnly]
    ]
    def getLakeFormationTagPolicies: ZIO[Any, AwsError, List[
      zio.aws.dataexchange.model.LakeFormationTagPolicyDetails.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "lakeFormationTagPolicies",
      lakeFormationTagPolicies
    )
    def getRedshiftDataShares: ZIO[Any, AwsError, List[
      zio.aws.dataexchange.model.RedshiftDataShareDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("redshiftDataShares", redshiftDataShares)
    def getS3DataAccesses: ZIO[Any, AwsError, List[
      zio.aws.dataexchange.model.S3DataAccessDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("s3DataAccesses", s3DataAccesses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ScopeDetails
  ) extends zio.aws.dataexchange.model.ScopeDetails.ReadOnly {
    override val lakeFormationTagPolicies: Optional[
      List[zio.aws.dataexchange.model.LakeFormationTagPolicyDetails.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lakeFormationTagPolicies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dataexchange.model.LakeFormationTagPolicyDetails.wrap(item)
        }.toList
      )
    override val redshiftDataShares: Optional[
      List[zio.aws.dataexchange.model.RedshiftDataShareDetails.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.redshiftDataShares())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dataexchange.model.RedshiftDataShareDetails.wrap(item)
        }.toList
      )
    override val s3DataAccesses: Optional[
      List[zio.aws.dataexchange.model.S3DataAccessDetails.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3DataAccesses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dataexchange.model.S3DataAccessDetails.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ScopeDetails
  ): zio.aws.dataexchange.model.ScopeDetails.ReadOnly = new Wrapper(impl)
}
