package zio.aws.dataexchange.model
import scala.jdk.CollectionConverters._
sealed trait SchemaChangeType {
  def unwrap
      : software.amazon.awssdk.services.dataexchange.model.SchemaChangeType
}
object SchemaChangeType {
  def wrap(
      value: software.amazon.awssdk.services.dataexchange.model.SchemaChangeType
  ): zio.aws.dataexchange.model.SchemaChangeType = value match {
    case software.amazon.awssdk.services.dataexchange.model.SchemaChangeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dataexchange.model.SchemaChangeType.ADD =>
      val r = ADD
      r
    case software.amazon.awssdk.services.dataexchange.model.SchemaChangeType.REMOVE =>
      val r = REMOVE
      r
    case software.amazon.awssdk.services.dataexchange.model.SchemaChangeType.MODIFY =>
      val r = MODIFY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dataexchange.model.SchemaChangeType {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.SchemaChangeType =
      software.amazon.awssdk.services.dataexchange.model.SchemaChangeType.UNKNOWN_TO_SDK_VERSION
  }
  case object ADD extends zio.aws.dataexchange.model.SchemaChangeType {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.SchemaChangeType =
      software.amazon.awssdk.services.dataexchange.model.SchemaChangeType.ADD
  }
  case object REMOVE extends zio.aws.dataexchange.model.SchemaChangeType {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.SchemaChangeType =
      software.amazon.awssdk.services.dataexchange.model.SchemaChangeType.REMOVE
  }
  case object MODIFY extends zio.aws.dataexchange.model.SchemaChangeType {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.SchemaChangeType =
      software.amazon.awssdk.services.dataexchange.model.SchemaChangeType.MODIFY
  }
}
