package zio.aws.dataexchange.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.dataexchange.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class SchemaChangeRequestDetails(
    changes: Optional[
      Iterable[zio.aws.dataexchange.model.SchemaChangeDetails]
    ] = Optional.Absent,
    schemaChangeAt: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.SchemaChangeRequestDetails = {
    import SchemaChangeRequestDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.SchemaChangeRequestDetails
      .builder()
      .optionallyWith(
        changes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.changes)
      .schemaChangeAt(Timestamp.unwrap(schemaChangeAt): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.dataexchange.model.SchemaChangeRequestDetails.ReadOnly =
    zio.aws.dataexchange.model.SchemaChangeRequestDetails.wrap(buildAwsValue())
}
object SchemaChangeRequestDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.SchemaChangeRequestDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.SchemaChangeRequestDetails =
      zio.aws.dataexchange.model.SchemaChangeRequestDetails(
        changes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        schemaChangeAt
      )
    def changes: Optional[
      List[zio.aws.dataexchange.model.SchemaChangeDetails.ReadOnly]
    ]
    def schemaChangeAt: Timestamp
    def getChanges: ZIO[Any, AwsError, List[
      zio.aws.dataexchange.model.SchemaChangeDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("changes", changes)
    def getSchemaChangeAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(schemaChangeAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.SchemaChangeRequestDetails
  ) extends zio.aws.dataexchange.model.SchemaChangeRequestDetails.ReadOnly {
    override val changes: Optional[
      List[zio.aws.dataexchange.model.SchemaChangeDetails.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.changes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dataexchange.model.SchemaChangeDetails.wrap(item)
        }.toList
      )
    override val schemaChangeAt: Timestamp =
      zio.aws.dataexchange.model.primitives.Timestamp(impl.schemaChangeAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.SchemaChangeRequestDetails
  ): zio.aws.dataexchange.model.SchemaChangeRequestDetails.ReadOnly =
    new Wrapper(impl)
}
