package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SchemaChangeDetails(
    name: __string,
    `type`: zio.aws.dataexchange.model.SchemaChangeType,
    description: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.SchemaChangeDetails = {
    import SchemaChangeDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.SchemaChangeDetails
      .builder()
      .name(name: java.lang.String)
      .`type`(`type`.unwrap)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.SchemaChangeDetails.ReadOnly =
    zio.aws.dataexchange.model.SchemaChangeDetails.wrap(buildAwsValue())
}
object SchemaChangeDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.SchemaChangeDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.SchemaChangeDetails =
      zio.aws.dataexchange.model
        .SchemaChangeDetails(name, `type`, description.map(value => value))
    def name: __string
    def `type`: zio.aws.dataexchange.model.SchemaChangeType
    def description: Optional[__string]
    def getName: ZIO[Any, Nothing, __string] = ZIO.succeed(name)
    def getType
        : ZIO[Any, Nothing, zio.aws.dataexchange.model.SchemaChangeType] =
      ZIO.succeed(`type`)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.SchemaChangeDetails
  ) extends zio.aws.dataexchange.model.SchemaChangeDetails.ReadOnly {
    override val name: __string = impl.name(): __string
    override val `type`: zio.aws.dataexchange.model.SchemaChangeType =
      zio.aws.dataexchange.model.SchemaChangeType.wrap(impl.`type`())
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.SchemaChangeDetails
  ): zio.aws.dataexchange.model.SchemaChangeDetails.ReadOnly = new Wrapper(impl)
}
