package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3DataAccessDetails(
    keyPrefixes: Optional[Iterable[__string]] = Optional.Absent,
    keys: Optional[Iterable[__string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.S3DataAccessDetails = {
    import S3DataAccessDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.S3DataAccessDetails
      .builder()
      .optionallyWith(
        keyPrefixes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.keyPrefixes)
      .optionallyWith(
        keys.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.keys)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.S3DataAccessDetails.ReadOnly =
    zio.aws.dataexchange.model.S3DataAccessDetails.wrap(buildAwsValue())
}
object S3DataAccessDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.S3DataAccessDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.S3DataAccessDetails =
      zio.aws.dataexchange.model.S3DataAccessDetails(
        keyPrefixes.map(value => value),
        keys.map(value => value)
      )
    def keyPrefixes: Optional[List[__string]]
    def keys: Optional[List[__string]]
    def getKeyPrefixes: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("keyPrefixes", keyPrefixes)
    def getKeys: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("keys", keys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.S3DataAccessDetails
  ) extends zio.aws.dataexchange.model.S3DataAccessDetails.ReadOnly {
    override val keyPrefixes: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.keyPrefixes())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val keys: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.keys())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.S3DataAccessDetails
  ): zio.aws.dataexchange.model.S3DataAccessDetails.ReadOnly = new Wrapper(impl)
}
