package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RedshiftDataShareDetails(
    arn: __string,
    database: __string,
    function: Optional[__string] = Optional.Absent,
    table: Optional[__string] = Optional.Absent,
    schema: Optional[__string] = Optional.Absent,
    view: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.RedshiftDataShareDetails = {
    import RedshiftDataShareDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.RedshiftDataShareDetails
      .builder()
      .arn(arn: java.lang.String)
      .database(database: java.lang.String)
      .optionallyWith(function.map(value => value: java.lang.String))(
        _.function
      )
      .optionallyWith(table.map(value => value: java.lang.String))(_.table)
      .optionallyWith(schema.map(value => value: java.lang.String))(_.schema)
      .optionallyWith(view.map(value => value: java.lang.String))(_.view)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.RedshiftDataShareDetails.ReadOnly =
    zio.aws.dataexchange.model.RedshiftDataShareDetails.wrap(buildAwsValue())
}
object RedshiftDataShareDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.RedshiftDataShareDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.RedshiftDataShareDetails =
      zio.aws.dataexchange.model.RedshiftDataShareDetails(
        arn,
        database,
        function.map(value => value),
        table.map(value => value),
        schema.map(value => value),
        view.map(value => value)
      )
    def arn: __string
    def database: __string
    def function: Optional[__string]
    def table: Optional[__string]
    def schema: Optional[__string]
    def view: Optional[__string]
    def getArn: ZIO[Any, Nothing, __string] = ZIO.succeed(arn)
    def getDatabase: ZIO[Any, Nothing, __string] = ZIO.succeed(database)
    def getFunction: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("function", function)
    def getTable: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("table", table)
    def getSchema: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("schema", schema)
    def getView: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("view", view)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.RedshiftDataShareDetails
  ) extends zio.aws.dataexchange.model.RedshiftDataShareDetails.ReadOnly {
    override val arn: __string = impl.arn(): __string
    override val database: __string = impl.database(): __string
    override val function: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.function())
      .map(value => value: __string)
    override val table: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.table())
      .map(value => value: __string)
    override val schema: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.schema())
      .map(value => value: __string)
    override val view: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.view())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.RedshiftDataShareDetails
  ): zio.aws.dataexchange.model.RedshiftDataShareDetails.ReadOnly = new Wrapper(
    impl
  )
}
