package zio.aws.dataexchange.model
import scala.jdk.CollectionConverters._
sealed trait NotificationType {
  def unwrap
      : software.amazon.awssdk.services.dataexchange.model.NotificationType
}
object NotificationType {
  def wrap(
      value: software.amazon.awssdk.services.dataexchange.model.NotificationType
  ): zio.aws.dataexchange.model.NotificationType = value match {
    case software.amazon.awssdk.services.dataexchange.model.NotificationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dataexchange.model.NotificationType.DATA_DELAY =>
      val r = DATA_DELAY
      r
    case software.amazon.awssdk.services.dataexchange.model.NotificationType.DATA_UPDATE =>
      val r = DATA_UPDATE
      r
    case software.amazon.awssdk.services.dataexchange.model.NotificationType.DEPRECATION =>
      val r = DEPRECATION
      r
    case software.amazon.awssdk.services.dataexchange.model.NotificationType.SCHEMA_CHANGE =>
      val r = SCHEMA_CHANGE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dataexchange.model.NotificationType {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.NotificationType =
      software.amazon.awssdk.services.dataexchange.model.NotificationType.UNKNOWN_TO_SDK_VERSION
  }
  case object DATA_DELAY extends zio.aws.dataexchange.model.NotificationType {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.NotificationType =
      software.amazon.awssdk.services.dataexchange.model.NotificationType.DATA_DELAY
  }
  case object DATA_UPDATE extends zio.aws.dataexchange.model.NotificationType {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.NotificationType =
      software.amazon.awssdk.services.dataexchange.model.NotificationType.DATA_UPDATE
  }
  case object DEPRECATION extends zio.aws.dataexchange.model.NotificationType {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.NotificationType =
      software.amazon.awssdk.services.dataexchange.model.NotificationType.DEPRECATION
  }
  case object SCHEMA_CHANGE
      extends zio.aws.dataexchange.model.NotificationType {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.NotificationType =
      software.amazon.awssdk.services.dataexchange.model.NotificationType.SCHEMA_CHANGE
  }
}
