package zio.aws.dataexchange.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NotificationDetails(
    dataUpdate: Optional[zio.aws.dataexchange.model.DataUpdateRequestDetails] =
      Optional.Absent,
    deprecation: Optional[
      zio.aws.dataexchange.model.DeprecationRequestDetails
    ] = Optional.Absent,
    schemaChange: Optional[
      zio.aws.dataexchange.model.SchemaChangeRequestDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.NotificationDetails = {
    import NotificationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.NotificationDetails
      .builder()
      .optionallyWith(dataUpdate.map(value => value.buildAwsValue()))(
        _.dataUpdate
      )
      .optionallyWith(deprecation.map(value => value.buildAwsValue()))(
        _.deprecation
      )
      .optionallyWith(schemaChange.map(value => value.buildAwsValue()))(
        _.schemaChange
      )
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.NotificationDetails.ReadOnly =
    zio.aws.dataexchange.model.NotificationDetails.wrap(buildAwsValue())
}
object NotificationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.NotificationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.NotificationDetails =
      zio.aws.dataexchange.model.NotificationDetails(
        dataUpdate.map(value => value.asEditable),
        deprecation.map(value => value.asEditable),
        schemaChange.map(value => value.asEditable)
      )
    def dataUpdate
        : Optional[zio.aws.dataexchange.model.DataUpdateRequestDetails.ReadOnly]
    def deprecation: Optional[
      zio.aws.dataexchange.model.DeprecationRequestDetails.ReadOnly
    ]
    def schemaChange: Optional[
      zio.aws.dataexchange.model.SchemaChangeRequestDetails.ReadOnly
    ]
    def getDataUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.DataUpdateRequestDetails.ReadOnly
    ] = AwsError.unwrapOptionField("dataUpdate", dataUpdate)
    def getDeprecation: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.DeprecationRequestDetails.ReadOnly
    ] = AwsError.unwrapOptionField("deprecation", deprecation)
    def getSchemaChange: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.SchemaChangeRequestDetails.ReadOnly
    ] = AwsError.unwrapOptionField("schemaChange", schemaChange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.NotificationDetails
  ) extends zio.aws.dataexchange.model.NotificationDetails.ReadOnly {
    override val dataUpdate: Optional[
      zio.aws.dataexchange.model.DataUpdateRequestDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataUpdate())
      .map(value =>
        zio.aws.dataexchange.model.DataUpdateRequestDetails.wrap(value)
      )
    override val deprecation: Optional[
      zio.aws.dataexchange.model.DeprecationRequestDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deprecation())
      .map(value =>
        zio.aws.dataexchange.model.DeprecationRequestDetails.wrap(value)
      )
    override val schemaChange: Optional[
      zio.aws.dataexchange.model.SchemaChangeRequestDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaChange())
      .map(value =>
        zio.aws.dataexchange.model.SchemaChangeRequestDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.NotificationDetails
  ): zio.aws.dataexchange.model.NotificationDetails.ReadOnly = new Wrapper(impl)
}
