package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LakeFormationTagPolicyDetails(
    database: Optional[__string] = Optional.Absent,
    table: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.LakeFormationTagPolicyDetails = {
    import LakeFormationTagPolicyDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.LakeFormationTagPolicyDetails
      .builder()
      .optionallyWith(database.map(value => value: java.lang.String))(
        _.database
      )
      .optionallyWith(table.map(value => value: java.lang.String))(_.table)
      .build()
  }
  def asReadOnly
      : zio.aws.dataexchange.model.LakeFormationTagPolicyDetails.ReadOnly =
    zio.aws.dataexchange.model.LakeFormationTagPolicyDetails
      .wrap(buildAwsValue())
}
object LakeFormationTagPolicyDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.LakeFormationTagPolicyDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.LakeFormationTagPolicyDetails =
      zio.aws.dataexchange.model.LakeFormationTagPolicyDetails(
        database.map(value => value),
        table.map(value => value)
      )
    def database: Optional[__string]
    def table: Optional[__string]
    def getDatabase: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("database", database)
    def getTable: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("table", table)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.LakeFormationTagPolicyDetails
  ) extends zio.aws.dataexchange.model.LakeFormationTagPolicyDetails.ReadOnly {
    override val database: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.database())
      .map(value => value: __string)
    override val table: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.table())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.LakeFormationTagPolicyDetails
  ): zio.aws.dataexchange.model.LakeFormationTagPolicyDetails.ReadOnly =
    new Wrapper(impl)
}
