package zio.aws.dataexchange.model
import scala.jdk.CollectionConverters._
sealed trait LakeFormationDataPermissionType {
  def unwrap: software.amazon.awssdk.services.dataexchange.model.LakeFormationDataPermissionType
}
object LakeFormationDataPermissionType {
  def wrap(
      value: software.amazon.awssdk.services.dataexchange.model.LakeFormationDataPermissionType
  ): zio.aws.dataexchange.model.LakeFormationDataPermissionType = value match {
    case software.amazon.awssdk.services.dataexchange.model.LakeFormationDataPermissionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dataexchange.model.LakeFormationDataPermissionType.LF_TAG_POLICY =>
      val r = LFTagPolicy
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dataexchange.model.LakeFormationDataPermissionType {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.LakeFormationDataPermissionType =
      software.amazon.awssdk.services.dataexchange.model.LakeFormationDataPermissionType.UNKNOWN_TO_SDK_VERSION
  }
  case object LFTagPolicy
      extends zio.aws.dataexchange.model.LakeFormationDataPermissionType {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.LakeFormationDataPermissionType =
      software.amazon.awssdk.services.dataexchange.model.LakeFormationDataPermissionType.LF_TAG_POLICY
  }
}
