package zio.aws.dataexchange.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Details(
    importAssetFromSignedUrlJobErrorDetails: Optional[
      zio.aws.dataexchange.model.ImportAssetFromSignedUrlJobErrorDetails
    ] = Optional.Absent,
    importAssetsFromS3JobErrorDetails: Optional[
      Iterable[zio.aws.dataexchange.model.AssetSourceEntry]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.Details = {
    import Details.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.Details
      .builder()
      .optionallyWith(
        importAssetFromSignedUrlJobErrorDetails.map(value =>
          value.buildAwsValue()
        )
      )(_.importAssetFromSignedUrlJobErrorDetails)
      .optionallyWith(
        importAssetsFromS3JobErrorDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.importAssetsFromS3JobErrorDetails)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.Details.ReadOnly =
    zio.aws.dataexchange.model.Details.wrap(buildAwsValue())
}
object Details {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.Details
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.Details =
      zio.aws.dataexchange.model.Details(
        importAssetFromSignedUrlJobErrorDetails.map(value => value.asEditable),
        importAssetsFromS3JobErrorDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def importAssetFromSignedUrlJobErrorDetails: Optional[
      zio.aws.dataexchange.model.ImportAssetFromSignedUrlJobErrorDetails.ReadOnly
    ]
    def importAssetsFromS3JobErrorDetails
        : Optional[List[zio.aws.dataexchange.model.AssetSourceEntry.ReadOnly]]
    def getImportAssetFromSignedUrlJobErrorDetails: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.ImportAssetFromSignedUrlJobErrorDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "importAssetFromSignedUrlJobErrorDetails",
      importAssetFromSignedUrlJobErrorDetails
    )
    def getImportAssetsFromS3JobErrorDetails: ZIO[Any, AwsError, List[
      zio.aws.dataexchange.model.AssetSourceEntry.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "importAssetsFromS3JobErrorDetails",
      importAssetsFromS3JobErrorDetails
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.Details
  ) extends zio.aws.dataexchange.model.Details.ReadOnly {
    override val importAssetFromSignedUrlJobErrorDetails: Optional[
      zio.aws.dataexchange.model.ImportAssetFromSignedUrlJobErrorDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.importAssetFromSignedUrlJobErrorDetails())
      .map(value =>
        zio.aws.dataexchange.model.ImportAssetFromSignedUrlJobErrorDetails
          .wrap(value)
      )
    override val importAssetsFromS3JobErrorDetails
        : Optional[List[zio.aws.dataexchange.model.AssetSourceEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importAssetsFromS3JobErrorDetails())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dataexchange.model.AssetSourceEntry.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.Details
  ): zio.aws.dataexchange.model.Details.ReadOnly = new Wrapper(impl)
}
