package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DeprecationRequestDetails(deprecationAt: Timestamp) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.DeprecationRequestDetails = {
    import DeprecationRequestDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.DeprecationRequestDetails
      .builder()
      .deprecationAt(Timestamp.unwrap(deprecationAt): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.dataexchange.model.DeprecationRequestDetails.ReadOnly =
    zio.aws.dataexchange.model.DeprecationRequestDetails.wrap(buildAwsValue())
}
object DeprecationRequestDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.DeprecationRequestDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.DeprecationRequestDetails =
      zio.aws.dataexchange.model.DeprecationRequestDetails(deprecationAt)
    def deprecationAt: Timestamp
    def getDeprecationAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(deprecationAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.DeprecationRequestDetails
  ) extends zio.aws.dataexchange.model.DeprecationRequestDetails.ReadOnly {
    override val deprecationAt: Timestamp =
      zio.aws.dataexchange.model.primitives.Timestamp(impl.deprecationAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.DeprecationRequestDetails
  ): zio.aws.dataexchange.model.DeprecationRequestDetails.ReadOnly =
    new Wrapper(impl)
}
