package zio.aws.dataexchange.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.dataexchange.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class DataUpdateRequestDetails(
    dataUpdatedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.DataUpdateRequestDetails = {
    import DataUpdateRequestDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.DataUpdateRequestDetails
      .builder()
      .optionallyWith(
        dataUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.dataUpdatedAt)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.DataUpdateRequestDetails.ReadOnly =
    zio.aws.dataexchange.model.DataUpdateRequestDetails.wrap(buildAwsValue())
}
object DataUpdateRequestDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.DataUpdateRequestDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.DataUpdateRequestDetails =
      zio.aws.dataexchange.model
        .DataUpdateRequestDetails(dataUpdatedAt.map(value => value))
    def dataUpdatedAt: Optional[Timestamp]
    def getDataUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("dataUpdatedAt", dataUpdatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.DataUpdateRequestDetails
  ) extends zio.aws.dataexchange.model.DataUpdateRequestDetails.ReadOnly {
    override val dataUpdatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.dataUpdatedAt())
      .map(value => zio.aws.dataexchange.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.DataUpdateRequestDetails
  ): zio.aws.dataexchange.model.DataUpdateRequestDetails.ReadOnly = new Wrapper(
    impl
  )
}
