package zio.aws.dataexchange.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.dataexchange.model.primitives.{MaxResults, __string}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListJobsRequest(
    dataSetId: Optional[__string] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent,
    revisionId: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ListJobsRequest = {
    import ListJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ListJobsRequest
      .builder()
      .optionallyWith(dataSetId.map(value => value: java.lang.String))(
        _.dataSetId
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(revisionId.map(value => value: java.lang.String))(
        _.revisionId
      )
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.ListJobsRequest.ReadOnly =
    zio.aws.dataexchange.model.ListJobsRequest.wrap(buildAwsValue())
}
object ListJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ListJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.ListJobsRequest =
      zio.aws.dataexchange.model.ListJobsRequest(
        dataSetId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        revisionId.map(value => value)
      )
    def dataSetId: Optional[__string]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[__string]
    def revisionId: Optional[__string]
    def getDataSetId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("dataSetId", dataSetId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRevisionId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("revisionId", revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ListJobsRequest
  ) extends zio.aws.dataexchange.model.ListJobsRequest.ReadOnly {
    override val dataSetId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSetId())
      .map(value => value: __string)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.dataexchange.model.primitives.MaxResults(value))
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val revisionId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionId())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ListJobsRequest
  ): zio.aws.dataexchange.model.ListJobsRequest.ReadOnly = new Wrapper(impl)
}
