package zio.aws.dataexchange.model
import scala.jdk.CollectionConverters._
sealed trait LFPermission {
  def unwrap: software.amazon.awssdk.services.dataexchange.model.LFPermission
}
object LFPermission {
  def wrap(
      value: software.amazon.awssdk.services.dataexchange.model.LFPermission
  ): zio.aws.dataexchange.model.LFPermission = value match {
    case software.amazon.awssdk.services.dataexchange.model.LFPermission.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dataexchange.model.LFPermission.DESCRIBE =>
      val r = DESCRIBE
      r
    case software.amazon.awssdk.services.dataexchange.model.LFPermission.SELECT =>
      val r = SELECT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dataexchange.model.LFPermission {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.LFPermission =
      software.amazon.awssdk.services.dataexchange.model.LFPermission.UNKNOWN_TO_SDK_VERSION
  }
  case object DESCRIBE extends zio.aws.dataexchange.model.LFPermission {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.LFPermission =
      software.amazon.awssdk.services.dataexchange.model.LFPermission.DESCRIBE
  }
  case object SELECT extends zio.aws.dataexchange.model.LFPermission {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.LFPermission =
      software.amazon.awssdk.services.dataexchange.model.LFPermission.SELECT
  }
}
