package zio.aws.dataexchange.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DatabaseLFTagPolicyAndPermissions(
    expression: Iterable[zio.aws.dataexchange.model.LFTag],
    permissions: Iterable[
      zio.aws.dataexchange.model.DatabaseLFTagPolicyPermission
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.DatabaseLFTagPolicyAndPermissions = {
    import DatabaseLFTagPolicyAndPermissions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.DatabaseLFTagPolicyAndPermissions
      .builder()
      .expression(expression.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .permissionsWithStrings(permissions.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.dataexchange.model.DatabaseLFTagPolicyAndPermissions.ReadOnly =
    zio.aws.dataexchange.model.DatabaseLFTagPolicyAndPermissions
      .wrap(buildAwsValue())
}
object DatabaseLFTagPolicyAndPermissions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.DatabaseLFTagPolicyAndPermissions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dataexchange.model.DatabaseLFTagPolicyAndPermissions =
      zio.aws.dataexchange.model.DatabaseLFTagPolicyAndPermissions(
        expression.map { item =>
          item.asEditable
        },
        permissions
      )
    def expression: List[zio.aws.dataexchange.model.LFTag.ReadOnly]
    def permissions
        : List[zio.aws.dataexchange.model.DatabaseLFTagPolicyPermission]
    def getExpression
        : ZIO[Any, Nothing, List[zio.aws.dataexchange.model.LFTag.ReadOnly]] =
      ZIO.succeed(expression)
    def getPermissions: ZIO[Any, Nothing, List[
      zio.aws.dataexchange.model.DatabaseLFTagPolicyPermission
    ]] = ZIO.succeed(permissions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.DatabaseLFTagPolicyAndPermissions
  ) extends zio.aws.dataexchange.model.DatabaseLFTagPolicyAndPermissions.ReadOnly {
    override val expression: List[zio.aws.dataexchange.model.LFTag.ReadOnly] =
      impl
        .expression()
        .asScala
        .map { item =>
          zio.aws.dataexchange.model.LFTag.wrap(item)
        }
        .toList
    override val permissions
        : List[zio.aws.dataexchange.model.DatabaseLFTagPolicyPermission] = impl
      .permissions()
      .asScala
      .map { item =>
        zio.aws.dataexchange.model.DatabaseLFTagPolicyPermission.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.DatabaseLFTagPolicyAndPermissions
  ): zio.aws.dataexchange.model.DatabaseLFTagPolicyAndPermissions.ReadOnly =
    new Wrapper(impl)
}
