package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateS3DataAccessFromS3BucketRequestDetails(
    assetSource: zio.aws.dataexchange.model.S3DataAccessAssetSourceEntry,
    dataSetId: Id,
    revisionId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.CreateS3DataAccessFromS3BucketRequestDetails = {
    import CreateS3DataAccessFromS3BucketRequestDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.CreateS3DataAccessFromS3BucketRequestDetails
      .builder()
      .assetSource(assetSource.buildAwsValue())
      .dataSetId(Id.unwrap(dataSetId): java.lang.String)
      .revisionId(Id.unwrap(revisionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.dataexchange.model.CreateS3DataAccessFromS3BucketRequestDetails.ReadOnly =
    zio.aws.dataexchange.model.CreateS3DataAccessFromS3BucketRequestDetails
      .wrap(buildAwsValue())
}
object CreateS3DataAccessFromS3BucketRequestDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.CreateS3DataAccessFromS3BucketRequestDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dataexchange.model.CreateS3DataAccessFromS3BucketRequestDetails =
      zio.aws.dataexchange.model.CreateS3DataAccessFromS3BucketRequestDetails(
        assetSource.asEditable,
        dataSetId,
        revisionId
      )
    def assetSource
        : zio.aws.dataexchange.model.S3DataAccessAssetSourceEntry.ReadOnly
    def dataSetId: Id
    def revisionId: Id
    def getAssetSource: ZIO[
      Any,
      Nothing,
      zio.aws.dataexchange.model.S3DataAccessAssetSourceEntry.ReadOnly
    ] = ZIO.succeed(assetSource)
    def getDataSetId: ZIO[Any, Nothing, Id] = ZIO.succeed(dataSetId)
    def getRevisionId: ZIO[Any, Nothing, Id] = ZIO.succeed(revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.CreateS3DataAccessFromS3BucketRequestDetails
  ) extends zio.aws.dataexchange.model.CreateS3DataAccessFromS3BucketRequestDetails.ReadOnly {
    override val assetSource
        : zio.aws.dataexchange.model.S3DataAccessAssetSourceEntry.ReadOnly =
      zio.aws.dataexchange.model.S3DataAccessAssetSourceEntry
        .wrap(impl.assetSource())
    override val dataSetId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.dataSetId())
    override val revisionId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.revisionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.CreateS3DataAccessFromS3BucketRequestDetails
  ): zio.aws.dataexchange.model.CreateS3DataAccessFromS3BucketRequestDetails.ReadOnly =
    new Wrapper(impl)
}
