package zio.aws.dataexchange.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.dataexchange.model.primitives.{
  __stringMin10Max512,
  Timestamp,
  __boolean,
  Arn,
  __stringMin0Max16384,
  Id
}
import scala.jdk.CollectionConverters._
final case class RevisionEntry(
    arn: Arn,
    comment: Optional[__stringMin0Max16384] = Optional.Absent,
    createdAt: Timestamp,
    dataSetId: Id,
    finalized: Optional[__boolean] = Optional.Absent,
    id: Id,
    sourceId: Optional[Id] = Optional.Absent,
    updatedAt: Timestamp,
    revocationComment: Optional[__stringMin10Max512] = Optional.Absent,
    revoked: Optional[__boolean] = Optional.Absent,
    revokedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.RevisionEntry = {
    import RevisionEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.RevisionEntry
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .optionallyWith(comment.map(value => value: java.lang.String))(_.comment)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .dataSetId(Id.unwrap(dataSetId): java.lang.String)
      .optionallyWith(finalized.map(value => value: java.lang.Boolean))(
        _.finalized
      )
      .id(Id.unwrap(id): java.lang.String)
      .optionallyWith(
        sourceId.map(value => Id.unwrap(value): java.lang.String)
      )(_.sourceId)
      .updatedAt(Timestamp.unwrap(updatedAt): Instant)
      .optionallyWith(revocationComment.map(value => value: java.lang.String))(
        _.revocationComment
      )
      .optionallyWith(revoked.map(value => value: java.lang.Boolean))(_.revoked)
      .optionallyWith(revokedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.revokedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.RevisionEntry.ReadOnly =
    zio.aws.dataexchange.model.RevisionEntry.wrap(buildAwsValue())
}
object RevisionEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.RevisionEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.RevisionEntry =
      zio.aws.dataexchange.model.RevisionEntry(
        arn,
        comment.map(value => value),
        createdAt,
        dataSetId,
        finalized.map(value => value),
        id,
        sourceId.map(value => value),
        updatedAt,
        revocationComment.map(value => value),
        revoked.map(value => value),
        revokedAt.map(value => value)
      )
    def arn: Arn
    def comment: Optional[__stringMin0Max16384]
    def createdAt: Timestamp
    def dataSetId: Id
    def finalized: Optional[__boolean]
    def id: Id
    def sourceId: Optional[Id]
    def updatedAt: Timestamp
    def revocationComment: Optional[__stringMin10Max512]
    def revoked: Optional[__boolean]
    def revokedAt: Optional[Timestamp]
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getComment: ZIO[Any, AwsError, __stringMin0Max16384] =
      AwsError.unwrapOptionField("comment", comment)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getDataSetId: ZIO[Any, Nothing, Id] = ZIO.succeed(dataSetId)
    def getFinalized: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("finalized", finalized)
    def getId: ZIO[Any, Nothing, Id] = ZIO.succeed(id)
    def getSourceId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("sourceId", sourceId)
    def getUpdatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updatedAt)
    def getRevocationComment: ZIO[Any, AwsError, __stringMin10Max512] =
      AwsError.unwrapOptionField("revocationComment", revocationComment)
    def getRevoked: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("revoked", revoked)
    def getRevokedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("revokedAt", revokedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.RevisionEntry
  ) extends zio.aws.dataexchange.model.RevisionEntry.ReadOnly {
    override val arn: Arn =
      zio.aws.dataexchange.model.primitives.Arn(impl.arn())
    override val comment: Optional[__stringMin0Max16384] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value => value: __stringMin0Max16384)
    override val createdAt: Timestamp =
      zio.aws.dataexchange.model.primitives.Timestamp(impl.createdAt())
    override val dataSetId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.dataSetId())
    override val finalized: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.finalized())
      .map(value => value: __boolean)
    override val id: Id = zio.aws.dataexchange.model.primitives.Id(impl.id())
    override val sourceId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceId())
      .map(value => zio.aws.dataexchange.model.primitives.Id(value))
    override val updatedAt: Timestamp =
      zio.aws.dataexchange.model.primitives.Timestamp(impl.updatedAt())
    override val revocationComment: Optional[__stringMin10Max512] =
      zio.aws.core.internal
        .optionalFromNullable(impl.revocationComment())
        .map(value => value: __stringMin10Max512)
    override val revoked: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.revoked())
      .map(value => value: __boolean)
    override val revokedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.revokedAt())
      .map(value => zio.aws.dataexchange.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.RevisionEntry
  ): zio.aws.dataexchange.model.RevisionEntry.ReadOnly = new Wrapper(impl)
}
