package zio.aws.dataexchange.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LakeFormationDataPermissionDetails(
    lfTagPolicy: Optional[zio.aws.dataexchange.model.LFTagPolicyDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.LakeFormationDataPermissionDetails = {
    import LakeFormationDataPermissionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.LakeFormationDataPermissionDetails
      .builder()
      .optionallyWith(lfTagPolicy.map(value => value.buildAwsValue()))(
        _.lfTagPolicy
      )
      .build()
  }
  def asReadOnly
      : zio.aws.dataexchange.model.LakeFormationDataPermissionDetails.ReadOnly =
    zio.aws.dataexchange.model.LakeFormationDataPermissionDetails
      .wrap(buildAwsValue())
}
object LakeFormationDataPermissionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.LakeFormationDataPermissionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dataexchange.model.LakeFormationDataPermissionDetails =
      zio.aws.dataexchange.model.LakeFormationDataPermissionDetails(
        lfTagPolicy.map(value => value.asEditable)
      )
    def lfTagPolicy
        : Optional[zio.aws.dataexchange.model.LFTagPolicyDetails.ReadOnly]
    def getLfTagPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.dataexchange.model.LFTagPolicyDetails.ReadOnly
    ] = AwsError.unwrapOptionField("lfTagPolicy", lfTagPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.LakeFormationDataPermissionDetails
  ) extends zio.aws.dataexchange.model.LakeFormationDataPermissionDetails.ReadOnly {
    override val lfTagPolicy
        : Optional[zio.aws.dataexchange.model.LFTagPolicyDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lfTagPolicy())
        .map(value => zio.aws.dataexchange.model.LFTagPolicyDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.LakeFormationDataPermissionDetails
  ): zio.aws.dataexchange.model.LakeFormationDataPermissionDetails.ReadOnly =
    new Wrapper(impl)
}
