package zio.aws.dataexchange.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class LFTag(tagKey: String, tagValues: Iterable[String]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.LFTag = {
    import LFTag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.LFTag
      .builder()
      .tagKey(tagKey: java.lang.String)
      .tagValues(tagValues.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.dataexchange.model.LFTag.ReadOnly =
    zio.aws.dataexchange.model.LFTag.wrap(buildAwsValue())
}
object LFTag {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.LFTag
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dataexchange.model.LFTag =
      zio.aws.dataexchange.model.LFTag(tagKey, tagValues)
    def tagKey: String
    def tagValues: List[String]
    def getTagKey: ZIO[Any, Nothing, String] = ZIO.succeed(tagKey)
    def getTagValues: ZIO[Any, Nothing, List[String]] = ZIO.succeed(tagValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.LFTag
  ) extends zio.aws.dataexchange.model.LFTag.ReadOnly {
    override val tagKey: String = impl.tagKey(): String
    override val tagValues: List[String] = impl
      .tagValues()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.LFTag
  ): zio.aws.dataexchange.model.LFTag.ReadOnly = new Wrapper(impl)
}
