package zio.aws.dataexchange.model
import scala.jdk.CollectionConverters._
sealed trait LFResourceType {
  def unwrap: software.amazon.awssdk.services.dataexchange.model.LFResourceType
}
object LFResourceType {
  def wrap(
      value: software.amazon.awssdk.services.dataexchange.model.LFResourceType
  ): zio.aws.dataexchange.model.LFResourceType = value match {
    case software.amazon.awssdk.services.dataexchange.model.LFResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dataexchange.model.LFResourceType.TABLE =>
      val r = TABLE
      r
    case software.amazon.awssdk.services.dataexchange.model.LFResourceType.DATABASE =>
      val r = DATABASE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dataexchange.model.LFResourceType {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.LFResourceType =
      software.amazon.awssdk.services.dataexchange.model.LFResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object TABLE extends zio.aws.dataexchange.model.LFResourceType {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.LFResourceType =
      software.amazon.awssdk.services.dataexchange.model.LFResourceType.TABLE
  }
  case object DATABASE extends zio.aws.dataexchange.model.LFResourceType {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.LFResourceType =
      software.amazon.awssdk.services.dataexchange.model.LFResourceType.DATABASE
  }
}
