package zio.aws.dataexchange.model
import scala.jdk.CollectionConverters._
sealed trait ServerSideEncryptionTypes {
  def unwrap: software.amazon.awssdk.services.dataexchange.model.ServerSideEncryptionTypes
}
object ServerSideEncryptionTypes {
  def wrap(
      value: software.amazon.awssdk.services.dataexchange.model.ServerSideEncryptionTypes
  ): zio.aws.dataexchange.model.ServerSideEncryptionTypes = value match {
    case software.amazon.awssdk.services.dataexchange.model.ServerSideEncryptionTypes.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dataexchange.model.ServerSideEncryptionTypes.AWS_KMS =>
      val r = `aws:kms`
      r
    case software.amazon.awssdk.services.dataexchange.model.ServerSideEncryptionTypes.AES256 =>
      val r = AES256
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dataexchange.model.ServerSideEncryptionTypes {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.ServerSideEncryptionTypes =
      software.amazon.awssdk.services.dataexchange.model.ServerSideEncryptionTypes.UNKNOWN_TO_SDK_VERSION
  }
  case object `aws:kms`
      extends zio.aws.dataexchange.model.ServerSideEncryptionTypes {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.ServerSideEncryptionTypes =
      software.amazon.awssdk.services.dataexchange.model.ServerSideEncryptionTypes.AWS_KMS
  }
  case object AES256
      extends zio.aws.dataexchange.model.ServerSideEncryptionTypes {
    override def unwrap
        : software.amazon.awssdk.services.dataexchange.model.ServerSideEncryptionTypes =
      software.amazon.awssdk.services.dataexchange.model.ServerSideEncryptionTypes.AES256
  }
}
