package zio.aws.dataexchange.model
import zio.aws.dataexchange.model.primitives.Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ImportAssetsFromRedshiftDataSharesResponseDetails(
    assetSources: Iterable[
      zio.aws.dataexchange.model.RedshiftDataShareAssetSourceEntry
    ],
    dataSetId: Id,
    revisionId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dataexchange.model.ImportAssetsFromRedshiftDataSharesResponseDetails = {
    import ImportAssetsFromRedshiftDataSharesResponseDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dataexchange.model.ImportAssetsFromRedshiftDataSharesResponseDetails
      .builder()
      .assetSources(assetSources.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .dataSetId(Id.unwrap(dataSetId): java.lang.String)
      .revisionId(Id.unwrap(revisionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.dataexchange.model.ImportAssetsFromRedshiftDataSharesResponseDetails.ReadOnly =
    zio.aws.dataexchange.model.ImportAssetsFromRedshiftDataSharesResponseDetails
      .wrap(buildAwsValue())
}
object ImportAssetsFromRedshiftDataSharesResponseDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dataexchange.model.ImportAssetsFromRedshiftDataSharesResponseDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dataexchange.model.ImportAssetsFromRedshiftDataSharesResponseDetails =
      zio.aws.dataexchange.model
        .ImportAssetsFromRedshiftDataSharesResponseDetails(
          assetSources.map { item =>
            item.asEditable
          },
          dataSetId,
          revisionId
        )
    def assetSources: List[
      zio.aws.dataexchange.model.RedshiftDataShareAssetSourceEntry.ReadOnly
    ]
    def dataSetId: Id
    def revisionId: Id
    def getAssetSources: ZIO[Any, Nothing, List[
      zio.aws.dataexchange.model.RedshiftDataShareAssetSourceEntry.ReadOnly
    ]] = ZIO.succeed(assetSources)
    def getDataSetId: ZIO[Any, Nothing, Id] = ZIO.succeed(dataSetId)
    def getRevisionId: ZIO[Any, Nothing, Id] = ZIO.succeed(revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dataexchange.model.ImportAssetsFromRedshiftDataSharesResponseDetails
  ) extends zio.aws.dataexchange.model.ImportAssetsFromRedshiftDataSharesResponseDetails.ReadOnly {
    override val assetSources: List[
      zio.aws.dataexchange.model.RedshiftDataShareAssetSourceEntry.ReadOnly
    ] = impl
      .assetSources()
      .asScala
      .map { item =>
        zio.aws.dataexchange.model.RedshiftDataShareAssetSourceEntry.wrap(item)
      }
      .toList
    override val dataSetId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.dataSetId())
    override val revisionId: Id =
      zio.aws.dataexchange.model.primitives.Id(impl.revisionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dataexchange.model.ImportAssetsFromRedshiftDataSharesResponseDetails
  ): zio.aws.dataexchange.model.ImportAssetsFromRedshiftDataSharesResponseDetails.ReadOnly =
    new Wrapper(impl)
}
